import defaultTheme from 'tailwindcss/defaultTheme';
import forms from '@tailwindcss/forms';

/** @type {import('tailwindcss').Config} */
export default {
    darkMode: 'class',
    content: [
        './vendor/laravel/framework/src/Illuminate/Pagination/resources/views/*.blade.php',
        './storage/framework/views/*.php',
        './resources/views/**/*.blade.php',
    ],

    theme: {
        extend: {
            fontFamily: {
                sans: ['Outfit', 'Figtree', ...defaultTheme.fontFamily.sans],
                display: ['Outfit', 'sans-serif'],
            },
            colors: {
                // Crextio Theme (Light/Dashboard)
                crextio: {
                    bg: '#FDFBF7',       // Cream background
                    card: '#FFFFFF',     // White card
                    primary: '#1F2937',  // Dark text/elements
                    accent: '#FFD55A',   // Yellow accent
                    secondary: '#E5E7EB',// Light gray
                    text: '#111827',     // Main text
                    muted: '#6B7280',    // Muted text
                },
                // AMU Theme (Dark/Auth)
                amu: {
                    bg: '#edb809ff',       // Deep dark purple bg
                    card: '#2F2B3A',     // Lighter purple card
                    primary: '#edea3aff',  // Violet primary button
                    primaryHover: '#d9c428ff',
                    input: '#2F2B3A',    // Input bg
                    text: '#FFFFFF',     // White text
                    muted: '#9CA3AF',    // Gray text
                }
            },
            backgroundImage: {
                'amu-gradient': 'linear-gradient(135deg, #2E2A3E 0%, #1A1625 100%)',
                'glass': 'linear-gradient(180deg, rgba(255, 255, 255, 0.6) 0%, rgba(255, 255, 255, 0.3) 100%)',
            },
            boxShadow: {
                'soft': '0 10px 40px -10px rgba(0,0,0,0.08)',
                'glass': '0 8px 32px 0 rgba(31, 38, 135, 0.37)',
                'glow': '0 0 20px rgba(124, 58, 237, 0.5)',
            },
            animation: {
                'fade-in': 'fadeIn 0.5s ease-out',
                'slide-up': 'slideUp 0.5s ease-out',
                'float': 'float 3s ease-in-out infinite',
            },
            keyframes: {
                fadeIn: {
                    '0%': { opacity: '0' },
                    '100%': { opacity: '1' },
                },
                slideUp: {
                    '0%': { transform: 'translateY(20px)', opacity: '0' },
                    '100%': { transform: 'translateY(0)', opacity: '1' },
                },
                float: {
                    '0%, 100%': { transform: 'translateY(0)' },
                    '50%': { transform: 'translateY(-10px)' },
                },
            },
        },
    },

    plugins: [forms],
};
