<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            <?php echo e(__('User Management')); ?>

        </h2>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <!-- Header -->
            <div class="mb-8 animate-fade-in">
                <h1 class="text-3xl font-bold text-crextio-text font-display">User & Role Management</h1>
                <p class="text-gray-600 mt-1">Manage user roles and permissions</p>
            </div>

            <!-- Success/Error Messages -->
            <?php if(session('success')): ?>
            <div class="mb-6 bg-green-50 border border-green-200 text-green-800 px-4 py-3 rounded-lg animate-slide-up">
                <?php echo e(session('success')); ?>

            </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
            <div class="mb-6 bg-red-50 border border-red-200 text-red-800 px-4 py-3 rounded-lg animate-slide-up">
                <?php echo e(session('error')); ?>

            </div>
            <?php endif; ?>

            <!-- Statistics Cards -->
            <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-4 mb-8">
                <div class="bg-white rounded-lg shadow-soft p-4 animate-slide-up">
                    <p class="text-xs text-gray-600">Total Users</p>
                    <p class="text-2xl font-bold text-gray-900"><?php echo e($userStats['total']); ?></p>
                </div>
                <div class="bg-white rounded-lg shadow-soft p-4 animate-slide-up" style="animation-delay: 0.05s;">
                    <p class="text-xs text-gray-600">Admins</p>
                    <p class="text-2xl font-bold text-purple-600"><?php echo e($userStats['admins']); ?></p>
                </div>
                <div class="bg-white rounded-lg shadow-soft p-4 animate-slide-up" style="animation-delay: 0.1s;">
                    <p class="text-xs text-gray-600">Top Leaders</p>
                    <p class="text-2xl font-bold text-blue-600"><?php echo e($userStats['topLeaders']); ?></p>
                </div>
                <div class="bg-white rounded-lg shadow-soft p-4 animate-slide-up" style="animation-delay: 0.15s;">
                    <p class="text-xs text-gray-600">Leaders</p>
                    <p class="text-2xl font-bold text-green-600"><?php echo e($userStats['leaders']); ?></p>
                </div>
                <div class="bg-white rounded-lg shadow-soft p-4 animate-slide-up" style="animation-delay: 0.2s;">
                    <p class="text-xs text-gray-600">Treasurers</p>
                    <p class="text-2xl font-bold text-yellow-600"><?php echo e($userStats['treasurers']); ?></p>
                </div>
                <div class="bg-white rounded-lg shadow-soft p-4 animate-slide-up" style="animation-delay: 0.22s;">
                    <p class="text-xs text-gray-600">Reg. Treasurers</p>
                    <p class="text-2xl font-bold text-orange-600"><?php echo e($userStats['regionalTreasurers']); ?></p>
                </div>
                <div class="bg-white rounded-lg shadow-soft p-4 animate-slide-up" style="animation-delay: 0.25s;">
                    <p class="text-xs text-gray-600">Members</p>
                    <p class="text-2xl font-bold text-gray-600"><?php echo e($userStats['members']); ?></p>
                </div>
            </div>

            <!-- Users Table -->
            <div class="bg-white rounded-xl shadow-soft overflow-hidden animate-slide-up" style="animation-delay: 0.3s;">
                <div class="p-6 border-b border-gray-200">
                    <h3 class="text-lg font-bold text-gray-900">All Users</h3>
                </div>
                
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">User</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Email</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Current Role</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Region</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Assigned Leader</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Joined</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="hover:bg-gray-50 transition">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="flex items-center">
                                        <div class="h-10 w-10 flex-shrink-0">
                                            <div class="h-10 w-10 rounded-full bg-gradient-to-br from-blue-400 to-purple-500 flex items-center justify-center text-white font-bold">
                                                <?php echo e(strtoupper(substr($user->name, 0, 1))); ?>

                                            </div>
                                        </div>
                                        <div class="ml-4">
                                            <div class="text-sm font-medium text-gray-900"><?php echo e($user->name); ?></div>
                                            <?php if($user->id === auth()->id()): ?>
                                            <div class="text-xs text-gray-500">(You)</div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm text-gray-900"><?php echo e($user->email); ?></div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="px-3 py-1 inline-flex text-xs leading-5 font-semibold rounded-full
                                        <?php echo e($user->role === 'admin' ? 'bg-purple-100 text-purple-800' : ''); ?>

                                        <?php echo e($user->role === 'top-leader' ? 'bg-blue-100 text-blue-800' : ''); ?>

                                        <?php echo e($user->role === 'leader' ? 'bg-green-100 text-green-800' : ''); ?>

                                        <?php echo e($user->role === 'treasurer' ? 'bg-yellow-100 text-yellow-800' : ''); ?>

                                        <?php echo e($user->role === 'regional-treasurer' ? 'bg-orange-100 text-orange-800' : ''); ?>

                                        <?php echo e($user->role === 'user' ? 'bg-gray-100 text-gray-800' : ''); ?>">
                                        <?php echo e(ucfirst(str_replace('-', ' ', $user->role))); ?>

                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    <?php echo e($user->region ?? 'Global'); ?>

                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <?php
                                        $member = $user->member;
                                        $assignedLeader = $member ? $member->leader : null;
                                    ?>
                                    <?php if($member): ?>
                                        <?php if($assignedLeader): ?>
                                            <div class="flex items-center">
                                                <div class="h-6 w-6 rounded-full bg-green-100 flex items-center justify-center text-green-800 text-xs font-bold mr-2">
                                                    <?php echo e(strtoupper(substr($assignedLeader->name, 0, 1))); ?>

                                                </div>
                                                <span class="text-sm text-gray-900"><?php echo e($assignedLeader->name); ?></span>
                                            </div>
                                        <?php else: ?>
                                            <form action="<?php echo e(route('members.assign-leader', $member)); ?>" method="POST" class="flex items-center gap-1">
                                                <?php echo csrf_field(); ?>
                                                <select name="leader_id" required class="text-xs border-gray-300 rounded-md w-28">
                                                    <option value="">Assign...</option>
                                                    <?php $__currentLoopData = $leaders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $leader): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($leader->id); ?>"><?php echo e($leader->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <button type="submit" class="bg-amber-500 text-white px-2 py-1 rounded text-xs hover:bg-amber-600">Go</button>
                                            </form>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <span class="text-xs text-gray-400">No member profile</span>
                                    <?php endif; ?>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    <?php echo e($user->created_at->format('M d, Y')); ?>

                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                    <!-- Role & Region Change Form -->
                                    <form action="<?php echo e(route('users.update-role', $user)); ?>" method="POST" class="flex flex-col space-y-2">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('PATCH'); ?>
                                        <div class="flex space-x-2">
                                            <select name="role" class="text-xs border-gray-300 rounded-md shadow-sm focus:border-blue-300 focus:ring focus:ring-blue-200 focus:ring-opacity-50 w-32">
                                                <option value="user" <?php echo e($user->role === 'user' ? 'selected' : ''); ?>>Member</option>
                                                <option value="leader" <?php echo e($user->role === 'leader' ? 'selected' : ''); ?>>Leader</option>
                                                <option value="treasurer" <?php echo e($user->role === 'treasurer' ? 'selected' : ''); ?>>Treasurer</option>
                                                <option value="regional-treasurer" <?php echo e($user->role === 'regional-treasurer' ? 'selected' : ''); ?>>Regional Treasurer</option>
                                                <option value="top-leader" <?php echo e($user->role === 'top-leader' ? 'selected' : ''); ?>>Top Leader</option>
                                                <?php if(auth()->user()->role === 'admin'): ?>
                                                <option value="admin" <?php echo e($user->role === 'admin' ? 'selected' : ''); ?>>Admin</option>
                                                <?php endif; ?>
                                            </select>
                                            
                                            <select name="region" class="text-xs border-gray-300 rounded-md shadow-sm focus:border-blue-300 focus:ring focus:ring-blue-200 focus:ring-opacity-50 w-32">
                                                <option value="">Global</option>
                                                <?php $__currentLoopData = $regions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($r->name); ?>" <?php echo e($user->region === $r->name ? 'selected' : ''); ?>><?php echo e($r->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            
                                            <button type="submit" class="bg-blue-600 text-white px-2 py-1 rounded text-xs hover:bg-blue-700 transition">Update</button>
                                        </div>
                                    </form>

                                    <div class="flex items-center space-x-2 mt-2">
                                        <!-- Delete Button -->
                                        <?php if($user->id !== auth()->id()): ?>
                                        <form action="<?php echo e(route('users.destroy', $user)); ?>" method="POST" class="inline-block" 
                                            onsubmit="return confirm('Are you sure you want to delete <?php echo e($user->name); ?>? This action cannot be undone.')">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="text-red-600 hover:text-red-900 text-xs flex items-center">
                                                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                                </svg>
                                                Delete
                                            </button>
                                        </form>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="5" class="px-6 py-4 text-center text-gray-500">No users found</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="px-6 py-4 border-t border-gray-200">
                    <?php echo e($users->links()); ?>

                </div>
            </div>

            <!-- Role Descriptions -->
            <div class="mt-8 bg-blue-50 rounded-xl p-6 animate-slide-up" style="animation-delay: 0.4s;">
                <h3 class="text-lg font-bold text-gray-900 mb-4">Role Descriptions</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm">
                    <div>
                        <strong class="text-purple-800">Admin:</strong>
                        <p class="text-gray-700">Full system access, can manage all users and settings</p>
                    </div>
                    <div>
                        <strong class="text-blue-800">Top Leader:</strong>
                        <p class="text-gray-700">Final loan approval, manage regions, view all data</p>
                    </div>
                    <div>
                        <strong class="text-green-800">Leader:</strong>
                        <p class="text-gray-700">First-level loan approval, manage assigned region members</p>
                    </div>
                    <div>
                        <strong class="text-yellow-800">Treasurer:</strong>
                        <p class="text-gray-700">Financial management, exports, disbursements</p>
                    </div>
                    <div>
                        <strong class="text-orange-800">Regional Treasurer:</strong>
                        <p class="text-gray-700">Financial management for assigned region only</p>
                    </div>
                    <div>
                        <strong class="text-gray-800">Member:</strong>
                        <p class="text-gray-700">Basic access, can request loans, view own data</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH /var/www/html/Arise/resources/views/admin/users/index.blade.php ENDPATH**/ ?>