<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Personal Statement</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 40px;
            color: #333;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 3px solid #3B82F6;
            padding-bottom: 20px;
        }
        .header h1 {
            color: #3B82F6;
            margin: 0;
            font-size: 28px;
        }
        .header p {
            margin: 5px 0;
            color: #666;
        }
        .info-box {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        .info-row {
            display: flex;
            justify-content: space-between;
            margin: 5px 0;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }
        th {
            background: #3B82F6;
            color: white;
            padding: 10px;
            text-align: left;
        }
        td {
            padding: 8px;
            border-bottom: 1px solid #ddd;
        }
        tr:nth-child(even) {
            background: #f8f9fa;
        }
        .summary {
            background: #e0f2fe;
            padding: 15px;
            border-radius: 5px;
            margin-top: 20px;
        }
        .summary h3 {
            margin-top: 0;
            color: #3B82F6;
        }
        .footer {
            text-align: center;
            margin-top: 40px;
            font-size: 12px;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>ARISE FAMILY</h1>
        <p>Personal Contribution Statement</p>
    </div>

    <div class="info-box">
        <div class="info-row">
            <strong>Member Name:</strong>
            <span><?php echo e($user->name); ?></span>
        </div>
        <div class="info-row">
            <strong>Email:</strong>
            <span><?php echo e($user->email); ?></span>
        </div>
        <div class="info-row">
            <strong>Statement Date:</strong>
            <span><?php echo e($generatedDate); ?></span>
        </div>
    </div>

    <h2>Contribution History</h2>

    <table>
        <thead>
            <tr>
                <th>Date</th>
                <th>Payment Method</th>
                <th style="text-align: right;">Amount (TZS)</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $contributions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contribution): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
                <td><?php echo e($contribution->contribution_date->format('d M Y')); ?></td>
                <td><?php echo e(ucfirst(str_replace('_', ' ', $contribution->payment_method))); ?></td>
                <td style="text-align: right;"><?php echo e(number_format($contribution->amount, 0)); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td colspan="3" style="text-align: center; padding: 20px;">No contributions found</td>
            </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <div class="summary">
        <h3>Summary</h3>
        <div class="info-row">
            <strong>Total Contributions:</strong>
            <strong style="color: #3B82F6; font-size: 18px;">TZS <?php echo e(number_format($totalContributions, 0)); ?></strong>
        </div>
        <div class="info-row">
            <strong>Number of Contributions:</strong>
            <span><?php echo e($contributions->count()); ?></span>
        </div>
    </div>

    <div class="footer">
        <p>This is a computer-generated statement. No signature is required.</p>
        <p>Generated on <?php echo e($generatedDate); ?> | ARISE Family Management System</p>
    </div>
</body>
</html>
<?php /**PATH /var/www/html/Arise/resources/views/pdfs/member-statement.blade.php ENDPATH**/ ?>