<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            <?php echo e(__('My Loan Requests')); ?>

        </h2>
        <div class="py-10">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-1">
            <!-- Header -->
            <div class="mb-8 animate-fade-in">
                <div class="flex justify-between items-center">
                    <div>
                        <h1 class="text-3xl font-bold text-crextio-text font-display">My Loan Requests</h1>
                        <p class="text-gray-600 mt-1">Track your loan applications and their status</p>
                    </div>
                    <a href="<?php echo e(route('loans.create')); ?>" class="inline-flex items-center px-6 py-3 bg-crextio-accent hover:bg-yellow-500 text-gray-900 font-medium rounded-lg transition-all duration-300 shadow-soft hover:shadow-md">
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                        </svg>
                        Request Loan
                    </a>
                </div>
            </div>

            <!-- Success Message -->
            <?php if(session('success')): ?>
                <div class="mb-6 bg-green-50 border-l-4 border-green-500 p-4 rounded-lg animate-slide-up">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 text-green-500 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                        </svg>
                        <p class="text-green-700 font-medium"><?php echo e(session('success')); ?></p>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Loans Grid -->
            <?php $__empty_1 = true; $__currentLoopData = $loans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $loan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="bg-white rounded-xl shadow-soft p-6 mb-6 animate-slide-up hover:shadow-md transition-all duration-300" style="animation-delay: <?php echo e($index * 0.1); ?>s;">
                    <div class="flex flex-col md:flex-row md:items-center md:justify-between">
                        <!-- Loan Info -->
                        <div class="flex-1 mb-4 md:mb-0">
                            <div class="flex items-center mb-2">
                                <div class="p-2 bg-purple-100 rounded-lg mr-3">
                                    <svg class="w-6 h-6 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                                    </svg>
                                </div>
                                <div>
                                    <h3 class="text-xl font-bold text-gray-900">TZS <?php echo e(number_format($loan->amount)); ?></h3>
                                    <p class="text-sm text-gray-500"><?php echo e($loan->purpose); ?></p>
                                </div>
                            </div>
                            
                            <div class="flex flex-wrap gap-3 mt-3">
                                <!-- Status Badge -->
                                <span class="px-3 py-1 text-xs font-semibold rounded-full <?php echo e($loan->getStatusBadgeColor()); ?>">
                                    <?php echo e($loan->getStatusText()); ?>

                                </span>
                                
                                <!-- Requested Date -->
                                <span class="px-3 py-1 text-xs font-medium bg-gray-100 text-gray-700 rounded-full">
                                    Requested: <?php echo e($loan->created_at->format('M d, Y')); ?>

                                </span>
                                
                                <!-- Approved Date -->
                                <?php if($loan->approved_at): ?>
                                    <span class="px-3 py-1 text-xs font-medium bg-gray-100 text-gray-700 rounded-full">
                                        <?php echo e($loan->isApproved() ? 'Approved' : 'Rejected'); ?>: <?php echo e($loan->approved_at->format('M d, Y')); ?>

                                    </span>
                                <?php endif; ?>
                                
                                <!-- Disbursed Date -->
                                <?php if($loan->isPaid()): ?>
                                    <span class="px-3 py-1 text-xs font-medium bg-blue-100 text-blue-700 rounded-full">
                                        Disbursed: <?php echo e($loan->disbursed_at->format('M d, Y')); ?>

                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>

                        <!-- Actions -->
                        <div class="flex items-center space-x-3">
                            <!-- Progress Indicator -->
                            <div class="hidden md:flex items-center space-x-2 mr-4">
                                <?php
                                    $steps = [
                                        ['label' => 'Requested', 'completed' => true],
                                        ['label' => 'Reviewed', 'completed' => !$loan->isPending()],
                                        ['label' => 'Approved', 'completed' => $loan->isApproved()],
                                        ['label' => 'Disbursed', 'completed' => $loan->isPaid()],
                                    ];
                                ?>
                                <?php $__currentLoopData = $steps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $step): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="flex flex-col items-center">
                                        <div class="w-8 h-8 rounded-full flex items-center justify-center <?php echo e($step['completed'] ? 'bg-green-500' : 'bg-gray-300'); ?>">
                                            <?php if($step['completed']): ?>
                                                <svg class="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 20 20">
                                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                                </svg>
                                            <?php else: ?>
                                                <span class="text-xs text-white font-bold"><?php echo e($loop->iteration); ?></span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <?php if(!$loop->last): ?>
                                        <div class="w-8 h-1 <?php echo e($steps[$loop->iteration]['completed'] ?? false ? 'bg-green-500' : 'bg-gray-300'); ?>"></div>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                            
                            <!-- View Details Button -->
                            <a href="<?php echo e(route('loans.show', $loan)); ?>" class="inline-flex items-center px-4 py-2 bg-gray-100 hover:bg-gray-200 text-gray-900 font-medium rounded-lg transition-all duration-300">
                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                </svg>
                                View Details
                            </a>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="bg-white rounded-xl shadow-soft p-12 text-center animate-fade-in">
                    <svg class="w-16 h-16 text-gray-300 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">No loan requests yet</h3>
                    <p class="text-gray-500 mb-6">You haven't submitted any loan requests.</p>
                    <a href="<?php echo e(route('loans.create')); ?>" class="inline-flex items-center px-6 py-3 bg-crextio-accent hover:bg-yellow-500 text-gray-900 font-medium rounded-lg transition-all duration-300 shadow-soft hover:shadow-md">
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                        </svg>
                        Request Your First Loan
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
     <?php $__env->endSlot(); ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH /var/www/html/Arise/resources/views/loans/index.blade.php ENDPATH**/ ?>