<!DOCTYPE html>
<html>
<head>
    <title>Arise Family</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        th, td { border: 1px solid #000; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        h2 { text-align: center; margin-bottom: 20px; }
    </style>
</head>

<body>
    <h2>Arise family</h2>
    <h3>Report Date: <?php echo e(now()->format('d M Y')); ?></h3>

    <div class="report-period" style="text-align: center; margin-bottom: 20px; font-weight: bold;">
    Report Period: 
        <?php switch($period):
            case ('day'): ?>
                Last Day
                <?php break; ?>
            <?php case ('week'): ?>
                Last Week
                <?php break; ?>
            <?php case ('month'): ?>
                Last Month
                <?php break; ?>
            <?php case ('three_months'): ?>
                Last Three Months
                <?php break; ?>
            <?php case ('six_months'): ?>
                Last Six Months
                <?php break; ?>
            <?php case ('year'): ?>
                Last Year
                <?php break; ?>
            <?php default: ?>
                Last Month
        <?php endswitch; ?>
    </div>


    <h3>Members</h3>
    <table>
        <thead>
            <tr>
                <th>Member ID</th>
                <th>Name</th>
                <th>Phone</th>
                <th>Join Date</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($member->member_number); ?></td>
                <td><?php echo e($member->name); ?></td>
                <td><?php echo e($member->phone); ?></td>
                <td><?php echo e($member->join_date->format('d M Y')); ?></td>
                <td><?php echo e(ucfirst($member->status)); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <h3>Transactions</h3>
    <table>
        <thead>
            <tr>
                <th>Transaction ID</th>
                <th>Member</th>
                <th>Amount</th>
                <th>Payment Method</th>
                <th>Date</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($transaction->id); ?></td>
                <td><?php echo e($transaction->member->name); ?></td>
                <td>TSH <?php echo e(number_format($transaction->amount)); ?></td>
                <td><?php echo e($transaction->payment_method); ?></td>
                <td><?php echo e($transaction->created_at->format('d M Y')); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</body>
</html>
<?php /**PATH /var/www/html/Arise/resources/views/reports/export.blade.php ENDPATH**/ ?>