<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            <?php echo e(__('Treasurer Dashboard')); ?>

        </h2>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <!-- Header -->
            <div class="mb-8 flex flex-col md:flex-row justify-between items-start md:items-center gap-6 animate-fade-in">
                <div class="relative">
                    <h1 class="text-4xl font-black text-crextio-text font-display tracking-tight">
                        <?php if(isset($isRegional) && $isRegional): ?>
                            <span class="text-crextio-accent">Regional</span> Finance
                        <?php else: ?>
                            Treasury <span class="text-crextio-accent"></span>
                        <?php endif; ?>
                    </h1>
                    <p class="text-crextio-muted mt-2 font-medium flex items-center">
                        <span class="w-2 h-2 bg-green-500 rounded-full mr-2 animate-pulse"></span>
                        Live Financial Overview • <?php echo e(now()->format('l, jS F Y')); ?>

                    </p>
                </div>
                
                <div class="flex flex-wrap gap-4">
                    <a href="<?php echo e(route('contributions.create', ['contribution_type' => 'social'])); ?>" 
                       class="px-6 py-3 bg-gradient-to-r from-orange-500 to-red-600 hover:from-orange-600 hover:to-red-700 text-white text-sm font-bold rounded-xl transition-all shadow-glow hover:scale-105 active:scale-95 flex items-center">
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                        </svg>
                        Record Social
                    </a>
                    <a href="<?php echo e(route('contributions.create', ['contribution_type' => 'share'])); ?>" 
                       class="px-6 py-3 bg-gradient-to-r from-indigo-600 to-purple-700 hover:from-indigo-700 hover:to-purple-800 text-white text-sm font-bold rounded-xl transition-all shadow-glow hover:scale-105 active:scale-95 flex items-center">
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                        </svg>
                        Record Share
                    </a>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 mb-12">
                <!-- Total Contributions Card -->
                <div class="lg:col-span-2 glass rounded-[2rem] shadow-soft p-8 animate-slide-up bg-gradient-to-br from-white/80 to-blue-50/50 border border-white/40">
                    <div class="flex items-center justify-between mb-8">
                        <h3 class="text-sm font-bold text-crextio-muted uppercase tracking-[0.2em]">Collective Liquidity</h3>
                        <div class="p-3 bg-blue-500/10 rounded-2xl text-blue-600">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                            </svg>
                        </div>
                    </div>
                    <div class="grid grid-cols-1 sm:grid-cols-3 gap-8">
                        <div class="group">
                            <p class="text-xs text-crextio-muted mb-2 uppercase font-semibold">Total Collections</p>
                            <p class="text-3xl font-black text-crextio-text leading-tight group-hover:text-blue-600 transition-colors">
                                <span class="text-sm font-normal text-crextio-muted mr-1">TZS</span><?php echo e(number_format($totalContributions, 0)); ?>

                            </p>
                        </div>
                        <div class="border-l border-gray-100/50 pl-8 group">
                            <p class="text-xs text-orange-500 mb-2 uppercase font-bold">Social Funds</p>
                            <p class="text-2xl font-black text-crextio-text leading-tight group-hover:text-orange-500 transition-colors">
                                <span class="text-sm font-normal text-crextio-muted mr-1">TZS</span><?php echo e(number_format($socialContributions, 0)); ?>

                            </p>
                        </div>
                        <div class="border-l border-gray-100/50 pl-8 group">
                            <p class="text-xs text-indigo-500 mb-2 uppercase font-bold">Share Capital</p>
                            <p class="text-2xl font-black text-crextio-text leading-tight group-hover:text-indigo-500 transition-colors">
                                <span class="text-sm font-normal text-crextio-muted mr-1">TZS</span><?php echo e(number_format($shareContributions, 0)); ?>

                            </p>
                        </div>
                    </div>
                </div>

                <!-- Monthly Card -->
                <div class="bg-gradient-to-br from-indigo-600 to-purple-800 rounded-[2rem] shadow-glow p-8 animate-slide-up text-white relative overflow-hidden" style="animation-delay: 0.1s;">
                    <div class="absolute -right-10 -top-10 w-40 h-40 bg-white/10 rounded-full blur-3xl"></div>
                    <div class="flex items-center justify-between mb-8 relative z-10">
                        <h3 class="text-sm font-bold uppercase tracking-[0.2em] opacity-80">Monthly Velocity</h3>
                        <div class="p-3 bg-white/20 rounded-2xl">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path>
                            </svg>
                        </div>
                    </div>
                    <div class="relative z-10">
                        <p class="text-xs opacity-70 mb-2 uppercase font-bold"><?php echo e(now()->format('F Y')); ?> Intake</p>
                        <p class="text-4xl font-black tabular-nums tracking-tighter">
                            <span class="text-lg font-normal opacity-60 mr-1">TZS</span><?php echo e(number_format($monthlyContributions, 0)); ?>

                        </p>
                        <div class="mt-8 flex items-center gap-2">
                            <span class="px-2 py-1 bg-white/20 rounded-md text-[10px] font-bold uppercase tracking-wider">Region Verified</span>
                        </div>
                    </div>
                </div>

                <!-- Summary Row -->
                <div class="glass rounded-2xl shadow-soft p-6 animate-slide-up flex items-center gap-5 hover:scale-[1.02] transition-all" style="animation-delay: 0.2s;">
                    <div class="p-4 bg-purple-500/10 rounded-2xl text-purple-600">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path>
                        </svg>
                    </div>
                    <div>
                        <p class="text-xl font-black text-crextio-text tracking-tight">TZS <?php echo e(number_format($outstandingLoans, 0)); ?></p>
                        <p class="text-xs text-crextio-muted font-bold uppercase">Loan Capital • <?php echo e($pendingLoans); ?> Pending</p>
                    </div>
                </div>

                <div class="glass rounded-2xl shadow-soft p-6 animate-slide-up flex items-center gap-5 hover:scale-[1.02] transition-all" style="animation-delay: 0.25s;">
                    <div class="p-4 bg-orange-500/10 rounded-2xl text-orange-600">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                        </svg>
                    </div>
                    <div>
                        <p class="text-xl font-black text-crextio-text tracking-tight"><?php echo e($activeMembers); ?> Active</p>
                        <p class="text-xs text-crextio-muted font-bold uppercase">Of <?php echo e($totalMembers); ?> Total Registry</p>
                    </div>
                </div>

                <div class="glass rounded-2xl shadow-soft p-6 animate-slide-up flex items-center gap-5 hover:scale-[1.02] transition-all" style="animation-delay: 0.3s;">
                    <div class="p-4 bg-emerald-500/10 rounded-2xl text-emerald-600">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"></path>
                        </svg>
                    </div>
                    <div>
                        <p class="text-xl font-black text-crextio-text tracking-tight uppercase">Audited</p>
                        <p class="text-xs text-emerald-600 font-black uppercase tracking-widest">100% Stability</p>
                    </div>
                </div>
            </div>

            <!-- Export Section -->
            <div class="glass rounded-[2rem] shadow-soft p-8 mb-12 animate-slide-up border border-white/40" style="animation-delay: 0.4s;">
                <h3 class="text-xl font-bold text-crextio-text mb-8 font-display flex items-center">
                    <div class="p-2 bg-crextio-accent/20 rounded-lg mr-3">
                        <svg class="w-6 h-6 text-crextio-text" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                    </div>
                    Intelligence Exports
                </h3>
                
                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
                    <!-- Export Contributions -->
                    <a href="<?php echo e(route('export.contributions')); ?>" 
                       class="group relative p-6 bg-white rounded-2xl border border-gray-100 shadow-soft hover:shadow-md transition-all duration-500 overflow-hidden">
                        <div class="absolute inset-0 bg-gradient-to-br from-blue-500/5 to-transparent opacity-0 group-hover:opacity-100 transition-opacity"></div>
                        <div class="relative z-10">
                            <div class="w-12 h-12 bg-blue-50 text-blue-600 rounded-xl flex items-center justify-center mb-4 group-hover:bg-blue-600 group-hover:text-white transition-all duration-500">
                                <svg class="w-7 h-7" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                                </svg>
                            </div>
                            <span class="block text-sm font-black text-crextio-text uppercase tracking-wider">Contributions</span>
                            <span class="text-xs text-crextio-muted mt-1 font-medium">Full Ledger PDF/XLS</span>
                        </div>
                    </a>

                    <!-- Export Transactions -->
                    <a href="<?php echo e(route('export.transactions')); ?>" 
                       class="group relative p-6 bg-white rounded-2xl border border-gray-100 shadow-soft hover:shadow-md transition-all duration-500 overflow-hidden">
                        <div class="absolute inset-0 bg-gradient-to-br from-green-500/5 to-transparent opacity-0 group-hover:opacity-100 transition-opacity"></div>
                        <div class="relative z-10">
                            <div class="w-12 h-12 bg-green-50 text-green-600 rounded-xl flex items-center justify-center mb-4 group-hover:bg-green-600 group-hover:text-white transition-all duration-500">
                                <svg class="w-7 h-7" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                </svg>
                            </div>
                            <span class="block text-sm font-black text-crextio-text uppercase tracking-wider">Transactions</span>
                            <span class="text-xs text-crextio-muted mt-1 font-medium">Audit Trail XLS</span>
                        </div>
                    </a>

                    <!-- Export Loans -->
                    <a href="<?php echo e(route('export.loans')); ?>" 
                       class="group relative p-6 bg-white rounded-2xl border border-gray-100 shadow-soft hover:shadow-md transition-all duration-500 overflow-hidden">
                        <div class="absolute inset-0 bg-gradient-to-br from-purple-500/5 to-transparent opacity-0 group-hover:opacity-100 transition-opacity"></div>
                        <div class="relative z-10">
                            <div class="w-12 h-12 bg-purple-50 text-purple-600 rounded-xl flex items-center justify-center mb-4 group-hover:bg-purple-600 group-hover:text-white transition-all duration-500">
                                <svg class="w-7 h-7" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path>
                                </svg>
                            </div>
                            <span class="block text-sm font-black text-crextio-text uppercase tracking-wider">Loan Portfolio</span>
                            <span class="text-xs text-crextio-muted mt-1 font-medium">Risk Analysis XLS</span>
                        </div>
                    </a>

                    <!-- Export Monthly Report -->
                    <a href="<?php echo e(route('export.monthly')); ?>" 
                       class="group relative p-6 bg-white rounded-2xl border border-gray-100 shadow-soft hover:shadow-md transition-all duration-500 overflow-hidden">
                        <div class="absolute inset-0 bg-gradient-to-br from-yellow-500/5 to-transparent opacity-0 group-hover:opacity-100 transition-opacity"></div>
                        <div class="relative z-10">
                            <div class="w-12 h-12 bg-yellow-50 text-yellow-600 rounded-xl flex items-center justify-center mb-4 group-hover:bg-yellow-600 group-hover:text-white transition-all duration-500">
                                <svg class="w-7 h-7" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                </svg>
                            </div>
                            <span class="block text-sm font-black text-crextio-text uppercase tracking-wider">Monthly Core</span>
                            <span class="text-xs text-crextio-muted mt-1 font-medium">Executive Summary XLS</span>
                        </div>
                    </a>
                </div>
            </div>

            <!-- PDF Reports Section -->
            <div class="glass rounded-[2rem] shadow-soft p-8 mb-12 animate-slide-up bg-white/50 border border-white/40" style="animation-delay: 0.42s;">
                <h3 class="text-xl font-bold text-crextio-text mb-8 font-display flex items-center">
                    <div class="p-2 bg-red-500/10 rounded-lg mr-3">
                        <svg class="w-6 h-6 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                        </svg>
                    </div>
                    Visual Documentation
                </h3>
                
                <form method="GET" action="<?php echo e(route('reports.exportPdf')); ?>" target="_blank" class="flex flex-col md:flex-row gap-6 items-end">
                    <div class="w-full md:w-1/3">
                        <label for="period" class="block text-xs font-black text-crextio-muted uppercase tracking-widest mb-3">Analysis Period</label>
                        <div class="relative">
                            <select name="period" id="period" class="w-full pl-4 pr-10 py-3 bg-white border border-gray-100 rounded-xl focus:ring-2 focus:ring-crextio-accent focus:border-transparent transition-all appearance-none font-medium text-crextio-text shadow-sm">
                                <option value="day">Today</option>
                                <option value="week">This Week</option>
                                <option value="month" selected>This Month</option>
                                <option value="three_months">Last 3 Months</option>
                                <option value="six_months">Last 6 Months</option>
                                <option value="year">This Year</option>
                            </select>
                            <div class="absolute right-3 top-1/2 -translate-y-1/2 pointer-events-none text-crextio-muted">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
                            </div>
                        </div>
                    </div>
                    <button type="submit" class="w-full md:w-auto px-8 py-3 bg-crextio-text hover:bg-black text-white font-bold rounded-xl transition-all duration-300 shadow-soft hover:shadow-glow flex items-center justify-center group overflow-hidden relative">
                        <div class="absolute inset-0 bg-gradient-to-r from-red-600/20 to-transparent opacity-0 group-hover:opacity-100 transition-opacity"></div>
                        <svg class="w-5 h-5 mr-2 relative z-10" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                        <span class="relative z-10">Compile PDF Manifest</span>
                    </button>
                </form>
            </div>

            <!-- Financial Charts Section -->
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 mb-12">
                <!-- Monthly Contributions Chart -->
                <div class="glass rounded-[2rem] shadow-soft p-8 animate-slide-up bg-white/50 border border-white/40" style="animation-delay: 0.45s;">
                    <h3 class="text-lg font-black text-crextio-text mb-6 flex items-center uppercase tracking-wider">
                        <div class="p-2 bg-blue-500/10 rounded-lg mr-3 text-blue-600">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path>
                            </svg>
                        </div>
                        Liquidity Flow
                    </h3>
                    <div class="h-72">
                        <canvas id="contributionsChart"></canvas>
                    </div>
                </div>

                <!-- Payment Methods Chart -->
                <div class="glass rounded-[2rem] shadow-soft p-8 animate-slide-up bg-white/50 border border-white/40" style="animation-delay: 0.475s;">
                    <h3 class="text-lg font-black text-crextio-text mb-6 flex items-center uppercase tracking-wider">
                        <div class="p-2 bg-emerald-500/10 rounded-lg mr-3 text-emerald-600">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 00 2-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                            </svg>
                        </div>
                        Inflow Composition
                    </h3>
                    <div class="h-72">
                        <canvas id="paymentMethodChart"></canvas>
                    </div>
                </div>

                <!-- Loan Status Chart -->
                <div class="glass rounded-[2rem] shadow-soft p-8 animate-slide-up lg:col-span-2 bg-white/50 border border-white/40" style="animation-delay: 0.5s;">
                    <h3 class="text-lg font-black text-crextio-text mb-6 flex items-center uppercase tracking-wider">
                        <div class="p-2 bg-purple-500/10 rounded-lg mr-3 text-purple-600">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                            </svg>
                        </div>
                        Portfolio Dispersion
                    </h3>
                    <div class="h-80">
                        <canvas id="loanStatusChart"></canvas>
                    </div>
                </div>
            </div>

            <!-- Recent Activity Section -->

            <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 mb-12">
                <!-- Recent Contributions -->
                <div class="glass rounded-[2rem] shadow-soft p-8 animate-slide-up bg-white/50 border border-white/40" style="animation-delay: 0.5s;">
                    <h3 class="text-lg font-black text-crextio-text mb-6 flex items-center uppercase tracking-wider">
                        <div class="p-2 bg-blue-500/10 rounded-lg mr-3 text-blue-600">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                            </svg>
                        </div>
                        Inflow Manifest
                    </h3>
                    <div class="space-y-4">
                        <?php $__empty_1 = true; $__currentLoopData = $recentContributions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contribution): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="flex items-center justify-between p-4 bg-white/60 rounded-2xl border border-white/40 hover:bg-white transition-all duration-300 group">
                            <div class="flex items-center">
                                <div class="h-12 w-12 bg-gradient-to-br from-blue-500 to-indigo-600 rounded-xl flex items-center justify-center mr-4 shadow-soft group-hover:rotate-6 transition-transform">
                                    <span class="text-sm font-black text-white"><?php echo e(substr($contribution->member->name ?? 'N', 0, 1)); ?></span>
                                </div>
                                <div>
                                    <p class="text-sm font-black text-crextio-text uppercase tracking-tight"><?php echo e($contribution->member->name ?? 'Unknown'); ?></p>
                                    <p class="text-[10px] text-crextio-muted font-bold tracking-widest uppercase"><?php echo e($contribution->contribution_date->format('M d, Y')); ?></p>
                                </div>
                            </div>
                            <div class="text-right">
                                <p class="text-sm font-black text-crextio-text">TZS <?php echo e(number_format($contribution->amount, 0)); ?></p>
                                <p class="text-[10px] text-blue-600 font-black uppercase tracking-widest"><?php echo e(ucfirst(str_replace('_', ' ', $contribution->payment_method))); ?></p>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="text-center py-8">
                            <p class="text-xs text-crextio-muted font-bold uppercase tracking-widest italic opacity-50">Empty Manifest</p>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Recent Loans -->
                <div class="glass rounded-[2rem] shadow-soft p-8 animate-slide-up bg-white/50 border border-white/40" style="animation-delay: 0.6s;">
                    <h3 class="text-lg font-black text-crextio-text mb-6 flex items-center uppercase tracking-wider">
                        <div class="p-2 bg-purple-500/10 rounded-lg mr-3 text-purple-600">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path>
                            </svg>
                        </div>
                        Portfolio Exposure
                    </h3>
                    <div class="space-y-4">
                        <?php $__empty_1 = true; $__currentLoopData = $recentLoans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="flex items-center justify-between p-4 bg-white/60 rounded-2xl border border-white/40 hover:bg-white transition-all duration-300 group">
                            <div class="flex items-center">
                                <div class="h-12 w-12 bg-gradient-to-br from-purple-500 to-fuchsia-600 rounded-xl flex items-center justify-center mr-4 shadow-soft group-hover:rotate-6 transition-transform">
                                    <span class="text-sm font-black text-white"><?php echo e(substr($loan->user->name ?? 'N', 0, 1)); ?></span>
                                </div>
                                <div>
                                    <p class="text-sm font-black text-crextio-text uppercase tracking-tight"><?php echo e($loan->user->name ?? 'Unknown'); ?></p>
                                    <p class="text-[10px] text-crextio-muted font-bold tracking-widest uppercase"><?php echo e($loan->created_at->format('M d, Y')); ?></p>
                                </div>
                            </div>
                            <div class="text-right">
                                <p class="text-sm font-black text-crextio-text">TZS <?php echo e(number_format($loan->amount, 0)); ?></p>
                                <span class="text-[9px] px-2 py-0.5 rounded-full font-black uppercase tracking-widest <?php echo e($loan->getStatusBadgeColor()); ?>">
                                    <?php echo e($loan->getStatusText()); ?>

                                </span>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="text-center py-8">
                            <p class="text-xs text-crextio-muted font-bold uppercase tracking-widest italic opacity-50">Zero Exposure</p>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Quick Access Links -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <!-- Contributions Link -->
                <a href="<?php echo e(route('contributions.index')); ?>" class="glass rounded-2xl shadow-soft p-8 hover:shadow-glow transition-all duration-500 animate-slide-up group border border-white/40" style="animation-delay: 0.7s;">
                    <div class="w-14 h-14 bg-blue-500/10 rounded-2xl flex items-center justify-center mb-6 group-hover:bg-blue-600 group-hover:text-white transition-all duration-500 text-blue-600">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg font-black text-crextio-text uppercase tracking-tight">Ledger Matrix</h3>
                    <p class="text-xs text-crextio-muted mt-2 font-bold uppercase tracking-widest">Global Inflow Management</p>
                </a>

                <!-- Loans Link -->
                <a href="<?php echo e(route('loans.pending')); ?>" class="glass rounded-2xl shadow-soft p-8 hover:shadow-glow transition-all duration-500 animate-slide-up group border border-white/40" style="animation-delay: 0.8s;">
                    <div class="w-14 h-14 bg-purple-500/10 rounded-2xl flex items-center justify-center mb-6 group-hover:bg-purple-600 group-hover:text-white transition-all duration-500 text-purple-600">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg font-black text-crextio-text uppercase tracking-tight">Risk Vector</h3>
                    <p class="text-xs text-crextio-muted mt-2 font-bold uppercase tracking-widest">Underwriting & Approvals</p>
                </a>

                <!-- Transactions Link -->
                <a href="<?php echo e(route('transactions.index')); ?>" class="glass rounded-2xl shadow-soft p-8 hover:shadow-glow transition-all duration-500 animate-slide-up group border border-white/40" style="animation-delay: 0.9s;">
                    <div class="w-14 h-14 bg-emerald-500/10 rounded-2xl flex items-center justify-center mb-6 group-hover:bg-emerald-600 group-hover:text-white transition-all duration-500 text-emerald-600">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg font-black text-crextio-text uppercase tracking-tight">Audit Stream</h3>
                    <p class="text-xs text-crextio-muted mt-2 font-bold uppercase tracking-widest">Immutable Transaction History</p>
                </a>
            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
    <!-- Chart.js Library -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Monthly Contributions Line Chart
            const contributionsCtx = document.getElementById('contributionsChart');
            if (contributionsCtx) {
                new Chart(contributionsCtx, {
                    type: 'line',
                    data: {
                        labels: <?php echo json_encode(array_column($monthlyData, 'month'), 512) ?>,
                        datasets: [{
                            label: 'Monthly Contributions (TZS)',
                            data: <?php echo json_encode(array_column($monthlyData, 'total'), 512) ?>,
                            borderColor: 'rgb(59, 130, 246)',
                            backgroundColor: 'rgba(59, 130, 246, 0.1)',
                            borderWidth: 3,
                            fill: true,
                            tension: 0.4,
                            pointBackgroundColor: 'rgb(59, 130, 246)',
                            pointBorderColor: '#fff',
                            pointBorderWidth: 2,
                            pointRadius: 5,
                            pointHoverRadius: 7
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        plugins: {
                            legend: {
                                display: false
                            },
                            tooltip: {
                                backgroundColor: 'rgba(0, 0, 0, 0.8)',
                                padding: 12,
                                bodyFont: {
                                    size: 14
                                },
                                callbacks: {
                                    label: function(context) {
                                        return 'TZS ' + context.parsed.y.toLocaleString();
                                    }
                                }
                            }
                        },
                        scales: {
                            y: {
                                beginAtZero: true,
                                ticks: {
                                    callback: function(value) {
                                        return 'TZS ' + (value / 1000) + 'K';
                                    }
                                },
                                grid: {
                                    color: 'rgba(0, 0, 0, 0.05)'
                                }
                            },
                            x: {
                                grid: {
                                    display: false
                                }
                            }
                        }
                    }
                });
            }

            // Payment Methods Pie Chart
            const paymentMethodCtx = document.getElementById('paymentMethodChart');
            if (paymentMethodCtx) {
                const paymentData = <?php echo json_encode($paymentMethods, 15, 512) ?>;
                const labels = paymentData.map(p => p.payment_method.replace('_', ' ').replace(/\b\w/g, l => l.toUpperCase()));
                const values = paymentData.map(p => p.total);
                
                new Chart(paymentMethodCtx, {
                    type: 'doughnut',
                    data: {
                        labels: labels,
                        datasets: [{
                            data: values,
                            backgroundColor: [
                                'rgba(59, 130, 246, 0.8)',
                                'rgba(16, 185, 129, 0.8)',
                                'rgba(251, 191, 36, 0.8)',
                                'rgba(139, 92, 246, 0.8)'
                            ],
                            borderColor: [
                                'rgb(59, 130, 246)',
                                'rgb(16, 185, 129)',
                                'rgb(251, 191, 36)',
                                'rgb(139, 92, 246)'
                            ],
                            borderWidth: 2
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        plugins: {
                            legend: {
                                position: 'bottom',
                                labels: {
                                    padding: 15,
                                    font: {
                                        size: 12
                                    }
                                }
                            },
                            tooltip: {
                                backgroundColor: 'rgba(0, 0, 0, 0.8)',
                                padding: 12,
                                callbacks: {
                                    label: function(context) {
                                        const label = context.label || '';
                                        const value = context.parsed || 0;
                                        const total = context.dataset.data.reduce((a, b) => a + b, 0);
                                        const percentage = ((value / total) * 100).toFixed(1);
                                        return label + ': TZS ' + value.toLocaleString() + ' (' + percentage + '%)';
                                    }
                                }
                            }
                        }
                    }
                });
            }

            // Loan Status Bar Chart
            const loanStatusCtx = document.getElementById('loanStatusChart');
            if (loanStatusCtx) {
                const loanStats = <?php echo json_encode($loanStats, 15, 512) ?>;
                
                new Chart(loanStatusCtx, {
                    type: 'bar',
                    data: {
                        labels: ['Pending Leader', 'Pending Top Leader', 'Approved', 'Disbursed', 'Rejected'],
                        datasets: [{
                            label: 'Number of Loans',
                            data: [
                                loanStats.pending_leader,
                                loanStats.pending_top_leader,
                                loanStats.approved,
                                loanStats.disbursed,
                                loanStats.rejected
                            ],
                            backgroundColor: [
                                'rgba(251, 191, 36, 0.8)',
                                'rgba(245, 158, 11, 0.8)',
                                'rgba(16, 185, 129, 0.8)',
                                'rgba(59, 130, 246, 0.8)',
                                'rgba(239, 68, 68, 0.8)'
                            ],
                            borderColor: [
                                'rgb(251, 191, 36)',
                                'rgb(245, 158, 11)',
                                'rgb(16, 185, 129)',
                                'rgb(59, 130, 246)',
                                'rgb(239, 68, 68)'
                            ],
                            borderWidth: 2,
                            borderRadius: 8
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        plugins: {
                            legend: {
                                display: false
                            },
                            tooltip: {
                                backgroundColor: 'rgba(0, 0, 0, 0.8)',
                                padding: 12,
                                callbacks: {
                                    label: function(context) {
                                        return 'Count: ' + context.parsed.y + ' loans';
                                    }
                                }
                            }
                        },
                        scales: {
                            y: {
                                beginAtZero: true,
                                ticks: {
                                    stepSize: 1
                                },
                                grid: {
                                    color: 'rgba(0, 0, 0, 0.05)'
                                }
                            },
                            x: {
                                grid: {
                                    display: false
                                }
                            }
                        }
                    }
                });
            }
        });
    </script>
    <?php $__env->stopPush(); ?>

   
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH /var/www/html/Arise/resources/views/treasurer/dashboard.blade.php ENDPATH**/ ?>