<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\MemberController;
use App\Http\Controllers\ContributionsController;
use App\Http\Controllers\TransactionController;
use App\Http\Controllers\ReportsController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\MessageSend;
use App\Http\Controllers\LoanController;
use App\Http\Controllers\SuggestedMemberController;
use App\Http\Controllers\RegionsController;
use App\Http\Controllers\ExportController;
use App\Http\Controllers\TreasurerDashboardController;
use App\Http\Controllers\MemberDashboardController;
use App\Http\Controllers\UserManagementController;
use App\Http\Controllers\RegionalContextController;
use App\Http\Controllers\PenaltyController;

Route::get('/', function () {
    return redirect()->route('login');
});

Route::get('/dashboard', [DashboardController::class, 'index'])->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::resource('members', MemberController::class)->middleware('role:leader,top-leader,admin');
    Route::get('/members/{member}/statement', [MemberController::class, 'downloadStatement'])->middleware('role:leader,top-leader,admin')->name('members.statement');
    Route::get('/members-unassigned', [MemberController::class, 'unassigned'])->middleware('role:top-leader,admin')->name('members.unassigned');
    Route::post('/members/{member}/assign-leader', [MemberController::class, 'assignLeader'])->middleware('role:top-leader,admin')->name('members.assign-leader');
    Route::get('/contributions', [ContributionsController::class, 'index'])->middleware('role:user,leader,top-leader,admin,treasurer,regional-treasurer')->name('contributions.index');
    Route::get('/contributions/create', [ContributionsController::class, 'create'])->name('contributions.create');
    Route::post('/contributions', [ContributionsController::class, 'store'])->name('contributions.store');
    Route::get('/transactions', [TransactionController::class, 'index'])->middleware('role:user,leader,top-leader,admin')->name('transactions.index');
    Route::get('/transactions/create', [TransactionController::class, 'create'])->middleware('role:user,leader,top-leader,admin')->name('transactions.create');
    Route::post('/transactions', [TransactionController::class, 'store'])->middleware('role:user,leader,top-leader,admin')->name('transactions.store');
    Route::get('/transactions/{transaction}', [TransactionController::class, 'show'])->middleware('role:user,leader,top-leader,admin')->name('transactions.show');
    Route::post('/transactions/{transaction}/reverse', [TransactionController::class, 'reverse'])->middleware('role:leader,top-leader,admin')->name('transactions.reverse');
    Route::get('/reports', [ReportsController::class, 'index'])->middleware('role:top-leader,admin,treasurer,regional-treasurer')->name('reports.index');
    Route::get('/reports/export', [ReportsController::class, 'exportPdf'])->middleware('role:top-leader,admin,treasurer,regional-treasurer')->name('reports.exportPdf');

    Route::resource('users', UserController::class)->only(['index'])->middleware('role:admin');
    Route::post('users/{user}/role', [UserController::class, 'updateRole'])->name('users.updateRole')->middleware('role:admin');

    Route::get('/suggested-members', [SuggestedMemberController::class, 'index'])->middleware('role:top-leader')->name('suggested-members.index');
    Route::get('/suggested-members/create', [SuggestedMemberController::class, 'create'])->middleware('role:leader,top-leader')->name('suggested-members.create');
    Route::post('/suggested-members', [SuggestedMemberController::class, 'store'])->middleware('role:leader,top-leader')->name('suggested-members.store');
    Route::patch('/suggested-members/{suggestedMember}/confirm', [SuggestedMemberController::class, 'confirm'])->middleware('role:top-leader')->name('suggested-members.confirm');

    Route::get('/messages/send', [MessageSend::class, 'index'])->middleware('role:admin,leader,top-leader')->name('messages.index');
    Route::post('/messages/send', [MessageSend::class, 'store'])->middleware('role:admin,leader,top-leader')->name('messages.store');
    Route::post('/messages/bulk-send', [MessageSend::class, 'bulkStore'])->middleware('role:admin,leader,top-leader')->name('messages.bulkStore');
    Route::get('/messages/member/{userId}', [MessageSend::class, 'memberMessages'])->middleware('role:admin,leader,top-leader')->name('messages.member');

    Route::get('/loans', [LoanController::class, 'index'])->middleware('role:user,leader,top-leader,admin,treasurer,regional-treasurer')->name('loans.index');
    Route::get('/loans/create', [LoanController::class, 'create'])->middleware('role:user,leader,top-leader,admin')->name('loans.create');
    Route::post('/loans', [LoanController::class, 'store'])->middleware('role:user,leader,top-leader,admin')->name('loans.store');
    Route::get('/loans/pending', [LoanController::class, 'pending'])->middleware('role:leader,top-leader,admin')->name('loans.pending');
    Route::get('/loans/{loan}', [LoanController::class, 'show'])->middleware('role:user,leader,top-leader,admin')->name('loans.show');
    Route::patch('/loans/{loan}/confirm', [LoanController::class, 'confirm'])->middleware('role:leader,top-leader,admin')->name('loans.confirm');
    Route::patch('/loans/{loan}/mark-paid', [LoanController::class, 'markAsPaid'])->middleware('role:top-leader,admin,treasurer,regional-treasurer')->name('loans.markAsPaid');

    // Regions management (top-leaders only)
    Route::get('/regions', [RegionsController::class, 'index'])->middleware('role:top-leader,admin')->name('regions.index');
    Route::post('/regions', [RegionsController::class, 'store'])->middleware('role:top-leader,admin')->name('regions.store');
    Route::post('/regions/assign', [RegionsController::class, 'assignLeader'])->middleware('role:top-leader,admin')->name('regions.assign');
    Route::delete('/regions/{leader}/remove', [RegionsController::class, 'removeLeader'])->middleware('role:top-leader,admin')->name('regions.remove');

    // Treasurer Dashboard and Exports
    Route::get('/treasurer', [TreasurerDashboardController::class, 'index'])->middleware('role:treasurer,top-leader,admin,regional-treasurer')->name('treasurer.dashboard');
    
    Route::get('/export/contributions', [ExportController::class, 'exportContributions'])->middleware('role:treasurer,top-leader,admin,regional-treasurer')->name('export.contributions');
    Route::get('/export/transactions', [ExportController::class, 'exportTransactions'])->middleware('role:treasurer,top-leader,admin,regional-treasurer')->name('export.transactions');
    Route::get('/export/loans', [ExportController::class, 'exportLoans'])->middleware('role:treasurer,top-leader,admin,regional-treasurer')->name('export.loans');
    Route::get('/export/monthly-report', [ExportController::class, 'exportMonthlyReport'])->middleware('role:treasurer,top-leader,admin,regional-treasurer')->name('export.monthly');
    
    // Member Self-Service Portal
    Route::get('/my-dashboard', [MemberDashboardController::class, 'index'])->name('member.dashboard');
    Route::get('/my-contributions', [MemberDashboardController::class, 'contributions'])->name('member.contributions');
    Route::get('/my-statement', [MemberDashboardController::class, 'downloadStatement'])->name('member.statement');
    
    // User Management (Top Leaders & Admins only)
    Route::get('/users', [UserManagementController::class, 'index'])->middleware('role:top-leader,admin')->name('users.index');
    Route::patch('/users/{user}/role', [UserManagementController::class, 'updateRole'])->middleware('role:top-leader,admin')->name('users.update-role');
    Route::delete('/users/{user}', [UserManagementController::class, 'destroy'])->middleware('role:top-leader,admin')->name('users.destroy');


    Route::post('/admin/select-region', [RegionalContextController::class, 'setSelectedRegion'])->middleware('role:top-leader,admin')->name('admin.select-region');

    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    // Penalties
    Route::middleware('role:leader,top-leader,admin,treasurer,regional-treasurer')->group(function () {
        Route::get('/penalties', [PenaltyController::class, 'index'])->name('penalties.index');
        Route::get('/penalties/create', [PenaltyController::class, 'create'])->name('penalties.create');
        Route::post('/penalties', [PenaltyController::class, 'store'])->name('penalties.store');
        Route::get('/penalties/{penalty}/pay', [PenaltyController::class, 'pay'])->name('penalties.pay');
        Route::post('/penalties/{penalty}/pay', [PenaltyController::class, 'processPayment'])->name('penalties.processPayment');
    });
});

require __DIR__.'/auth.php';
