{{-- @extends('layouts.app') --}}

<x-app-layout>
    <x-slot name="header">
           <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Transactions') }}
        </h2>



@section('content')
<div class="container">
    <h2>Total Transactions</h2>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <div class="table-responsive">
        <table class="table table-hover table-sm align-middle">
            <thead>
                <tr>
                    <th>Reference</th>
                    <th>Member</th>
                    <th>Type</th>
                    <th>Amount (TSH)</th>
                    <th>Balance Before</th>
                    <th>Balance After</th>
                    <th>Payment Method</th>
                    <th>Date</th>
                    <th>Recorded By</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach($transactions as $transaction)
                <tr>
                    <td>{{ $transaction->transaction_reference }}</td>
                    <td>{{ $transaction->member->name }}</td>
                    <td>{{ ucfirst(str_replace('_', ' ', $transaction->transaction_type)) }}</td>
                    <td>{{ number_format($transaction->amount) }}</td>
                    <td>{{ number_format($transaction->balance_before) }}</td>
                    <td>{{ number_format($transaction->balance_after) }}</td>
                    <td>{{ ucfirst($transaction->payment_method) }}</td>
                    <td>{{ $transaction->transaction_date->format('d M Y') }}</td>
                    <td>{{ $transaction->recorder->name ?? 'N/A' }}</td>
                    <td>
                        <a href="{{ route('transactions.show', $transaction->id) }}" class="btn btn-sm btn-outline-primary" title="View">
                            <i class="fas fa-eye"></i>
                        </a>
                        @if(!$transaction->reversed)
                        <form action="{{ route('transactions.reverse', $transaction->id) }}" method="POST" class="d-inline">
                            @csrf
                            @method('POST')
                            <button type="submit" class="btn btn-sm btn-outline-danger" title="Reverse" onclick="return confirm('Are you sure you want to reverse this transaction?')">
                                <i class="fas fa-undo"></i>
                            </button>
                        </form>
                        @endif
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    {{ $transactions->links() }}
</div>
@endsection
</x-slot>
</x-app-layout>