@extends('layouts.app')

@section('content')
<div class="container py-12">
    <div class="max-w-2xl mx-auto">
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6">
                <h1 class="text-2xl font-bold text-gray-900 dark:text-gray-100 mb-6">Record New Transaction</h1>

                <form method="POST" action="{{ route('transactions.store') }}">
                    @csrf

                    @if(auth()->user()->role !== 'user')
                    <!-- Member Selection -->
                    <div class="mb-4">
                        <x-input-label for="member_id" :value="__('Select Member')" />
                        <select name="member_id" id="member_id" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
                            <option value="">Choose a member...</option>
                            @foreach($members as $member)
                            <option value="{{ $member->id }}" {{ old('member_id') == $member->id ? 'selected' : '' }}>
                                {{ $member->name }} ({{ $member->phone }})
                            </option>
                            @endforeach
                        </select>
                        <x-input-error :messages="$errors->get('member_id')" class="mt-2" />
                    </div>
                    @else
                    <input type="hidden" name="member_id" value="{{ auth()->id() }}">
                    @endif

                    <!-- Transaction Type -->
                    <div class="mb-4">
                        <x-input-label for="transaction_type" :value="__('Transaction Type')" />
                        <select name="transaction_type" id="transaction_type" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
                            @foreach($types as $key => $value)
                            <option value="{{ $key }}" {{ old('transaction_type') == $key ? 'selected' : '' }}>
                                {{ $value }}
                            </option>
                            @endforeach
                        </select>
                        <x-input-error :messages="$errors->get('transaction_type')" class="mt-2" />
                    </div>

                    <!-- Amount -->
                    <div class="mb-4">
                        <x-input-label for="amount" :value="__('Amount (TZS)')" />
                        <x-text-input id="amount" class="block mt-1 w-full" type="number" step="0.01" name="amount" :value="old('amount')" required />
                        <x-input-error :messages="$errors->get('amount')" class="mt-2" />
                    </div>

                    <!-- Payment Method -->
                    <div class="mb-4">
                        <x-input-label for="payment_method" :value="__('Payment Method')" />
                        <select name="payment_method" id="payment_method" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
                            <option value="mpesa" {{ old('payment_method') == 'mpesa' ? 'selected' : '' }}>M-Pesa</option>
                            <option value="cash" {{ old('payment_method') == 'cash' ? 'selected' : '' }}>Cash</option>
                            <option value="bank_transfer" {{ old('payment_method') == 'bank_transfer' ? 'selected' : '' }}>Bank Transfer</option>
                            <option value="cheque" {{ old('payment_method') == 'cheque' ? 'selected' : '' }}>Cheque</option>
                        </select>
                        <x-input-error :messages="$errors->get('payment_method')" class="mt-2" />
                    </div>

                    <!-- M-Pesa Receipt (conditional) -->
                    <div class="mb-4" id="mpesa_receipt_field" style="display: none;">
                        <x-input-label for="mpesa_receipt" :value="__('M-Pesa Receipt Number')" />
                        <x-text-input id="mpesa_receipt" class="block mt-1 w-full" type="text" name="mpesa_receipt" :value="old('mpesa_receipt')" />
                        <x-input-error :messages="$errors->get('mpesa_receipt')" class="mt-2" />
                    </div>

                    <!-- Transaction Date -->
                    <div class="mb-4">
                        <x-input-label for="transaction_date" :value="__('Transaction Date')" />
                        <x-text-input id="transaction_date" class="block mt-1 w-full" type="date" name="transaction_date" :value="old('transaction_date', date('Y-m-d'))" required />
                        <x-input-error :messages="$errors->get('transaction_date')" class="mt-2" />
                    </div>

                    <!-- Description -->
                    <div class="mb-4">
                        <x-input-label for="description" :value="__('Description (Optional)')" />
                        <textarea name="description" id="description" rows="3" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">{{ old('description') }}</textarea>
                        <x-input-error :messages="$errors->get('description')" class="mt-2" />
                    </div>

                    <div class="flex items-center justify-end">
                        <a href="{{ route('transactions.index') }}" class="mr-4 text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-gray-100">Cancel</a>
                        <x-primary-button>
                            {{ __('Record Transaction') }}
                        </x-primary-button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
document.getElementById('payment_method').addEventListener('change', function() {
    const mpesaField = document.getElementById('mpesa_receipt_field');
    if (this.value === 'mpesa') {
        mpesaField.style.display = 'block';
        document.getElementById('mpesa_receipt').required = true;
    } else {
        mpesaField.style.display = 'none';
        document.getElementById('mpesa_receipt').required = false;
    }
});

// Trigger on page load if M-Pesa is selected
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('payment_method').dispatchEvent(new Event('change'));
});
</script>
@endsection
