<!DOCTYPE html>
<html>
<head>
    <title>Arise Family</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        th, td { border: 1px solid #000; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        h2 { text-align: center; margin-bottom: 20px; }
    </style>
</head>

<body>
    <h2>Arise family</h2>
    <h3>Report Date: {{ now()->format('d M Y') }}</h3>

    <div class="report-period" style="text-align: center; margin-bottom: 20px; font-weight: bold;">
    Report Period: 
        @switch($period)
            @case('day')
                Last Day
                @break
            @case('week')
                Last Week
                @break
            @case('month')
                Last Month
                @break
            @case('three_months')
                Last Three Months
                @break
            @case('six_months')
                Last Six Months
                @break
            @case('year')
                Last Year
                @break
            @default
                Last Month
        @endswitch
    </div>


    <h3>Members</h3>
    <table>
        <thead>
            <tr>
                <th>Member ID</th>
                <th>Name</th>
                <th>Phone</th>
                <th>Join Date</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            @foreach($members as $member)
            <tr>
                <td>{{ $member->member_number }}</td>
                <td>{{ $member->name }}</td>
                <td>{{ $member->phone }}</td>
                <td>{{ $member->join_date->format('d M Y') }}</td>
                <td>{{ ucfirst($member->status) }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <h3>Transactions</h3>
    <table>
        <thead>
            <tr>
                <th>Transaction ID</th>
                <th>Member</th>
                <th>Amount</th>
                <th>Payment Method</th>
                <th>Date</th>
            </tr>
        </thead>
        <tbody>
            @foreach($transactions as $transaction)
            <tr>
                <td>{{ $transaction->id }}</td>
                <td>{{ $transaction->member->name }}</td>
                <td>TSH {{ number_format($transaction->amount) }}</td>
                <td>{{ $transaction->payment_method }}</td>
                <td>{{ $transaction->created_at->format('d M Y') }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
