<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Regional Management') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <!-- Header -->
            <div class="mb-8 animate-fade-in">
                <h1 class="text-3xl font-bold text-crextio-text font-display">Regional Management</h1>
                <p class="text-gray-600 mt-1">Assign leaders and treasurers to regions</p>
            </div>

            <!-- Success/Error Messages -->
            @if(session('success'))
                <div class="mb-6 bg-green-50 border-l-4 border-green-500 p-4 rounded-lg animate-slide-up">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 text-green-500 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                        </svg>
                        <p class="text-green-700 font-medium">{{ session('success') }}</p>
                    </div>
                </div>
            @endif

            @if(session('error'))
                <div class="mb-6 bg-red-50 border-l-4 border-red-500 p-4 rounded-lg animate-slide-up">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 text-red-500 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"></path>
                        </svg>
                        <p class="text-red-700 font-medium">{{ session('error') }}</p>
                    </div>
                </div>
            @endif

            <!-- Region Management Actions -->
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 mb-8">
                <!-- Add New Region Form -->
                <div class="bg-white rounded-xl shadow-soft p-6 animate-slide-up">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4 font-display">Add New Region</h3>
                    <form method="POST" action="{{ route('regions.store') }}" class="space-y-4">
                        @csrf
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Region Name</label>
                            <input type="text" name="name" required placeholder="e.g., North, South, Central East..." 
                                   class="w-full px-4 py-3 border border-gray-200 rounded-lg focus:ring-2 focus:ring-crextio-accent focus:border-transparent transition-all">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Description (Optional)</label>
                            <textarea name="description" rows="1" placeholder="Brief description..." 
                                      class="w-full px-4 py-3 border border-gray-200 rounded-lg focus:ring-2 focus:ring-crextio-accent focus:border-transparent transition-all"></textarea>
                        </div>
                        <button type="submit" class="w-full px-6 py-3 bg-gray-900 hover:bg-black text-white font-medium rounded-lg transition-all duration-300 shadow-soft hover:shadow-md">
                            Create Region
                        </button>
                    </form>
                </div>

                <!-- Assign Leader Form -->
                <div class="bg-white rounded-xl shadow-soft p-6 animate-slide-up" style="animation-delay: 0.1s;">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4 font-display">Assign User to Region</h3>
                    <form method="POST" action="{{ route('regions.assign') }}" class="space-y-4">
                        @csrf
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Select Region</label>
                            <select name="region" required class="w-full px-4 py-3 border border-gray-200 rounded-lg focus:ring-2 focus:ring-crextio-accent focus:border-transparent transition-all">
                                <option value="">Choose a region...</option>
                                @foreach($allRegions as $r)
                                    <option value="{{ $r->name }}">{{ $r->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Select User (to promote/assign)</label>
                            <select name="leader_id" required class="w-full px-4 py-3 border border-gray-200 rounded-lg focus:ring-2 focus:ring-crextio-accent focus:border-transparent transition-all">
                                <option value="">Choose a user...</option>
                                @foreach($availableLeaders as $u)
                                    <option value="{{ $u->id }}">
                                        {{ $u->name }} 
                                        [{{ ucfirst(str_replace('-', ' ', $u->role)) }}] 
                                        {{ $u->region ? " - Current Region: {$u->region}" : '' }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Assign Role</label>
                            <select name="role" required class="w-full px-4 py-3 border border-gray-200 rounded-lg focus:ring-2 focus:ring-crextio-accent focus:border-transparent transition-all">
                                <option value="leader">Regional Leader</option>
                                <option value="regional-treasurer">Regional Treasurer</option>
                            </select>
                        </div>
                        <button type="submit" class="w-full px-6 py-3 bg-crextio-accent hover:bg-yellow-500 text-gray-900 font-medium rounded-lg transition-all duration-300 shadow-soft hover:shadow-md">
                            Assign Region
                        </button>
                    </form>
                </div>
            </div>

            <!-- Regions Grid -->
            <div class="grid grid-cols-1 gap-8">
                @forelse($allRegions as $region)
                    @php
                        $regionLeaders = $leadersByRegion->get($region->name, collect());
                    @endphp
                    <div class="bg-white rounded-xl shadow-soft overflow-hidden border border-gray-100 animate-slide-up" style="animation-delay: {{ $loop->index * 0.05 }}s;">
                        <div class="bg-gray-50 px-6 py-4 flex items-center justify-between border-b border-gray-100">
                            <div>
                                <h3 class="text-xl font-bold text-gray-900 font-display">{{ $region->name }}</h3>
                                @if($region->description)
                                    <p class="text-xs text-gray-500 mt-0.5">{{ $region->description }}</p>
                                @endif
                            </div>
                            <div class="flex items-center gap-3">
                                <span class="px-3 py-1 bg-white border border-gray-200 text-gray-700 text-xs font-semibold rounded-full shadow-xs">
                                    {{ $regionLeaders->count() }} Leaders/Treasurers
                                </span>
                            </div>
                        </div>

                        <div class="p-6">
                            @if($regionLeaders->count() > 0)
                                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                                    @foreach($regionLeaders as $leader)
                                        <div class="group bg-white border border-gray-100 rounded-xl p-4 hover:border-crextio-accent hover:shadow-soft transition-all duration-300">
                                            <div class="flex items-center justify-between mb-4">
                                                <div class="flex items-center">
                                                    <div class="h-10 w-10 bg-crextio-accent rounded-full flex items-center justify-center mr-3 ring-4 ring-crextio-accent/10">
                                                        <span class="text-sm font-bold text-gray-900">{{ substr($leader->name, 0, 1) }}</span>
                                                    </div>
                                                    <div>
                                                        <p class="text-sm font-bold text-gray-900">{{ $leader->name }}</p>
                                                        <p class="text-xs text-blue-600 font-medium">{{ ucfirst(str_replace('-', ' ', $leader->role)) }}</p>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="flex items-center justify-between pt-3 border-t border-gray-50">
                                                <div class="flex items-center text-gray-500 text-xs">
                                                    <svg class="w-4 h-4 mr-1 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                                                    </svg>
                                                    {{ $leader->members_count }} members
                                                </div>
                                                <form method="POST" action="{{ route('regions.remove', $leader->id) }}" class="inline" onsubmit="return confirm('Remove leader from this region?')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="text-gray-400 hover:text-red-600 transition-colors">
                                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                                        </svg>
                                                    </button>
                                                </form>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @else
                                <div class="text-center py-6 bg-gray-50 rounded-xl border border-dashed border-gray-200">
                                    <p class="text-sm text-gray-500 italic">No leaders assigned to this region yet</p>
                                </div>
                            @endif
                        </div>
                    </div>
                @empty
                    <div class="bg-white rounded-xl shadow-soft p-12 text-center animate-fade-in">
                        <svg class="w-16 h-16 text-gray-200 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 20l-5.447-2.724A1 1 0 013 16.382V5.618a1 1 0 011.447-.894L9 7m0 13l6-3m-6 3V7m6 10l4.553 2.276A1 1 0 0021 18.382V7.618a1 1 0 00-.553-.894L15 4m0 13V4m0 0L9 7"></path>
                        </svg>
                        <h3 class="text-xl font-bold text-gray-900 mb-2 font-display">No regions created yet</h3>
                        <p class="text-gray-500">Add your first region using the form above</p>
                    </div>
                @endforelse
            </div>

            <!-- Unassigned Leaders -->
            @if($unassignedLeaders->count() > 0)
                <div class="mt-12 bg-orange-50 rounded-xl border border-orange-100 p-6 animate-slide-up">
                    <div class="flex items-center mb-6">
                        <div class="p-2 bg-orange-100 rounded-lg mr-3">
                            <svg class="w-5 h-5 text-orange-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path>
                            </svg>
                        </div>
                        <h3 class="text-lg font-bold text-gray-900 font-display">Unassigned Leaders & Treasurers</h3>
                        <span class="ml-auto px-2.5 py-0.5 bg-orange-200 text-orange-800 text-xs font-bold rounded-full">
                            {{ $unassignedLeaders->count() }}
                        </span>
                    </div>
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                        @foreach($unassignedLeaders as $leader)
                            <div class="bg-white border border-orange-200 rounded-xl p-3 flex items-center shadow-sm">
                                <div class="h-8 w-8 bg-orange-100 rounded-full flex items-center justify-center mr-3">
                                    <span class="text-xs font-bold text-orange-700">{{ substr($leader->name, 0, 1) }}</span>
                                </div>
                                <div>
                                    <p class="text-xs font-bold text-gray-900 truncate w-32">{{ $leader->name }}</p>
                                    <p class="text-[10px] text-orange-600 font-medium">{{ ucfirst(str_replace('-', ' ', $leader->role)) }}</p>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            @endif
        </div>
    </div>
</x-app-layout>
