<x-app-layout>
    <x-slot name="header">
        <h2 class="font-bold text-2xl text-crextio-text leading-tight font-display tracking-tight">
            {{ __('Profile Dashboard') }}
        </h2>
    </x-slot>

    <div class="py-8 lg:py-12 bg-gray-50/30">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 lg:grid-cols-4 gap-6 lg:gap-8">
                
                <!-- Sidebar / Navigation Info -->
                <div class="lg:col-span-1">
                    <div class="bg-white rounded-2xl lg:rounded-[2rem] shadow-soft p-6 lg:p-8 border border-gray-100/50 lg:sticky lg:top-24">
                        <div class="flex flex-col items-center">
                            <div class="h-32 w-32 lg:h-36 lg:w-36 rounded-2xl lg:rounded-3xl overflow-hidden shadow-soft-xl hover:shadow-soft-2xl transition-all duration-500 hover:rotate-2 bg-crextio-accent p-1">
                                <div class="h-full w-full rounded-xl lg:rounded-[1.25rem] overflow-hidden bg-white">
                                    @if($user->profile_picture)
                                        <img src="{{ Storage::url($user->profile_picture) }}" class="h-full w-full object-cover" alt="{{ $user->name }}">
                                    @else
                                        <div class="h-full w-full flex items-center justify-center text-crextio-text font-black text-4xl lg:text-5xl">
                                            {{ substr($user->name, 0, 1) }}
                                        </div>
                                    @endif
                                </div>
                            </div>

                            <div class="mt-6 text-center w-full">
                                <h1 class="text-lg lg:text-xl font-black text-gray-900 font-display tracking-tight uppercase leading-tight break-words">{{ $user->name }}</h1>
                                <div class="mt-3 flex flex-wrap justify-center gap-2">
                                    <span class="px-3 py-1 bg-gray-900 text-white text-[10px] font-black uppercase tracking-widest rounded-full shadow-sm">{{ $user->role }}</span>
                                    <span class="px-3 py-1 bg-crextio-accent text-gray-900 text-[10px] font-black uppercase tracking-widest rounded-full shadow-sm">{{ $user->region ?? 'Central' }}</span>
                                </div>
                                <p class="mt-4 text-xs text-gray-400 font-medium leading-relaxed italic hidden lg:block">
                                    "Managing your personal organizational parameters with precision and elegance."
                                </p>
                            </div>

                            <div class="mt-6 w-full pt-6 border-t border-gray-50 flex justify-center gap-8">
                                <div class="text-center">
                                    <p class="text-[10px] font-black uppercase tracking-widest text-gray-400">Status</p>
                                    <p class="text-xs font-bold text-emerald-500 mt-1">Verified</p>
                                </div>
                                <div class="text-center">
                                    <p class="text-[10px] font-black uppercase tracking-widest text-gray-400">Account</p>
                                    <p class="text-xs font-bold text-gray-900 mt-1">Standard</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Main Content Area -->
                <div class="lg:col-span-3 space-y-6">
                    
                    <!-- Information Form -->
                    <div class="bg-white rounded-2xl lg:rounded-[2rem] shadow-soft-xl overflow-hidden border border-gray-100/50 hover:shadow-soft-2xl transition-all duration-500">
                        <div class="p-6 lg:p-8">
                            @include('profile.partials.update-profile-information-form')
                        </div>
                    </div>

                    <!-- Password Section -->
                    <div class="bg-white rounded-2xl lg:rounded-[2rem] shadow-soft overflow-hidden border border-gray-100/30 hover:shadow-soft-xl transition-all duration-500">
                        <div class="p-6 lg:p-8">
                            @include('profile.partials.update-password-form')
                        </div>
                    </div>

                    <!-- Security / Danger Zone -->
                    <div class="p-6 lg:p-8 bg-red-50/30 rounded-2xl lg:rounded-[2rem] border border-red-100/50 shadow-sm group hover:bg-red-50/50 transition-colors duration-500">
                        <div class="max-w-xl">
                            @include('profile.partials.delete-user-form')
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</x-app-layout>
