<x-app-layout>
    <x-slot name="header">
        <h2 class="font-black text-2xl text-crextio-text leading-tight uppercase tracking-tight">
            {{ __('Clear Penalty') }}
        </h2>
    </x-slot>

    <div class="py-12 bg-gray-50/50 min-h-screen">
        <div class="max-w-3xl mx-auto sm:px-6 lg:px-8">
            <div class="mb-8">
                <a href="{{ route('penalties.index') }}" class="text-xs font-black text-crextio-muted hover:text-crextio-text transition-colors flex items-center uppercase tracking-widest group">
                    <svg class="w-4 h-4 mr-2 group-hover:-translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                    </svg>
                    Back to Registry
                </a>
                <h1 class="text-3xl font-black text-crextio-text font-display mt-4">Resolve <span class="text-emerald-500">Inflow</span></h1>
                <p class="text-crextio-muted font-bold uppercase text-xs tracking-widest mt-1">Record payment for outstanding member penalty</p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-8 mb-8 animate-fade-in">
                <div class="md:col-span-2 glass rounded-[2rem] shadow-soft p-10 border border-white/40 bg-white/50">
                    <form method="POST" action="{{ route('penalties.processPayment', $penalty) }}">
                        @csrf

                        <!-- Payment Method -->
                        <div class="mb-8">
                            <label for="payment_method" class="block text-xs font-black text-crextio-muted uppercase tracking-widest mb-3">Remittance Method</label>
                            <div class="relative">
                                <select name="payment_method" id="payment_method" class="w-full pl-4 pr-10 py-4 bg-white border-2 border-gray-100 rounded-2xl focus:border-crextio-text focus:ring-0 transition-all appearance-none font-bold text-crextio-text shadow-sm" required onchange="toggleMpesa(this.value)">
                                    <option value="mpesa">M-PESA</option>
                                    <option value="cash">Cash</option>
                                    <option value="bank_transfer">Bank Transfer</option>
                                    <option value="cheque">Cheque</option>
                                </select>
                                <div class="absolute right-4 top-1/2 -translate-y-1/2 pointer-events-none text-crextio-muted">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                                    </svg>
                                </div>
                            </div>
                            <x-input-error :messages="$errors->get('payment_method')" class="mt-2" />
                        </div>

                        <!-- M-PESA Receipt (Conditional) -->
                        <div id="mpesa_field" class="mb-8">
                            <label for="mpesa_receipt" class="block text-xs font-black text-crextio-muted uppercase tracking-widest mb-3">M-PESA Reference Code</label>
                            <input type="text" name="mpesa_receipt" id="mpesa_receipt" class="w-full px-4 py-4 bg-white border-2 border-gray-100 rounded-2xl focus:border-crextio-text focus:ring-0 transition-all font-bold text-crextio-text shadow-sm uppercase placeholder-gray-300" placeholder="e.g. QWX1234567">
                            <x-input-error :messages="$errors->get('mpesa_receipt')" class="mt-2" />
                        </div>

                        <div class="flex items-center justify-end">
                            <button type="submit" class="w-full py-4 bg-emerald-600 hover:bg-emerald-700 text-white font-black rounded-2xl transition-all shadow-glow hover:shadow-emerald-500/50 uppercase tracking-[0.2em] transform active:scale-95">
                                Finalize Settlement
                            </button>
                        </div>
                    </form>
                </div>

                <div class="glass rounded-[2rem] shadow-soft p-8 border border-white/40 bg-gradient-to-br from-crextio-text to-gray-800 text-white flex flex-col justify-between">
                    <div>
                        <p class="text-[10px] font-black uppercase tracking-[0.2em] opacity-60 mb-2">Liability Summary</p>
                        <h3 class="text-xl font-black uppercase leading-tight">{{ $penalty->member->name }}</h3>
                        <div class="mt-6 space-y-4">
                            <div>
                                <p class="text-[10px] font-black uppercase tracking-widest opacity-40">Reason</p>
                                <p class="text-xs font-bold">{{ $penalty->reason }}</p>
                            </div>
                            <div>
                                <p class="text-[10px] font-black uppercase tracking-widest opacity-40">Issued By</p>
                                <p class="text-xs font-bold uppercase">{{ $penalty->issuer->name }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="mt-8 border-t border-white/10 pt-6">
                        <p class="text-[10px] font-black uppercase tracking-widest opacity-40 mb-1">Total Due</p>
                        <p class="text-3xl font-black">TZS {{ number_format($penalty->amount, 0) }}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        function toggleMpesa(val) {
            const field = document.getElementById('mpesa_field');
            const input = document.getElementById('mpesa_receipt');
            if (val === 'mpesa') {
                field.style.display = 'block';
                input.required = true;
            } else {
                field.style.display = 'none';
                input.required = false;
            }
        }
        // Initialize
        toggleMpesa(document.getElementById('payment_method').value);
    </script>
</x-app-layout>
