<x-app-layout>
    <x-slot name="header">
        <h2 class="font-black text-2xl text-crextio-text leading-tight uppercase tracking-tight">
            {{ __('Penalty Ledger') }}
        </h2>
    </x-slot>

    <div class="py-12 bg-gray-50/50 min-h-screen">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="mb-8 flex justify-between items-center">
                <div>
                    <h1 class="text-3xl font-black text-crextio-text font-display">Compliance <span class="text-crextio-accent">Audit</span></h1>
                    <p class="text-crextio-muted font-bold uppercase text-xs tracking-widest mt-1">Registry of issued and paid penalties</p>
                </div>
                <a href="{{ route('penalties.create') }}" class="px-6 py-3 bg-crextio-text hover:bg-black text-white text-sm font-black rounded-xl transition-all shadow-soft hover:shadow-glow flex items-center group uppercase tracking-wider">
                    <svg class="w-5 h-5 mr-2 group-hover:rotate-90 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                    </svg>
                    Issue Penalty
                </a>
            </div>

            @if(session('success'))
                <div class="mb-8 p-4 bg-emerald-500/10 border border-emerald-500/20 text-emerald-600 rounded-2xl font-bold animate-fade-in flex items-center">
                    <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    {{ session('success') }}
                </div>
            @endif

            <div class="glass rounded-[2rem] shadow-soft overflow-hidden border border-white/40 bg-white/50">
                <div class="overflow-x-auto">
                    <table class="w-full text-left border-collapse">
                        <thead>
                            <tr class="bg-crextio-text text-white">
                                <th class="px-8 py-5 text-[10px] font-black uppercase tracking-[0.2em]">Member</th>
                                <th class="px-8 py-5 text-[10px] font-black uppercase tracking-[0.2em]">Reason</th>
                                <th class="px-8 py-5 text-[10px] font-black uppercase tracking-[0.2em]">Amount</th>
                                <th class="px-8 py-5 text-[10px] font-black uppercase tracking-[0.2em]">Status</th>
                                <th class="px-8 py-5 text-[10px] font-black uppercase tracking-[0.2em]">Issued By</th>
                                <th class="px-8 py-5 text-[10px] font-black uppercase tracking-[0.2em] text-right">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100/50">
                            @forelse($penalties as $penalty)
                                <tr class="hover:bg-white/80 transition-colors group">
                                    <td class="px-8 py-6">
                                        <div class="flex items-center">
                                            <div class="h-10 w-10 bg-gradient-to-br from-crextio-text to-gray-700 rounded-xl flex items-center justify-center mr-4 shadow-soft group-hover:scale-110 transition-transform">
                                                <span class="text-white font-black text-xs">{{ substr($penalty->member->name, 0, 1) }}</span>
                                            </div>
                                            <div>
                                                <div class="text-sm font-black text-crextio-text uppercase tracking-tight">{{ $penalty->member->name }}</div>
                                                <div class="text-[10px] text-crextio-muted font-bold">{{ $penalty->created_at->format('M d, Y') }}</div>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="px-8 py-6">
                                        <div class="text-sm font-bold text-crextio-text">{{ $penalty->reason }}</div>
                                    </td>
                                    <td class="px-8 py-6">
                                        <div class="text-sm font-black text-crextio-text">TZS {{ number_format($penalty->amount, 0) }}</div>
                                    </td>
                                    <td class="px-8 py-6">
                                        @if($penalty->isPaid())
                                            <span class="px-3 py-1 bg-emerald-500/10 text-emerald-600 rounded-full text-[10px] font-black uppercase tracking-widest border border-emerald-500/20">
                                                Paid
                                            </span>
                                        @else
                                            <span class="px-3 py-1 bg-orange-500/10 text-orange-600 rounded-full text-[10px] font-black uppercase tracking-widest border border-orange-500/20">
                                                Pending
                                            </span>
                                        @endif
                                    </td>
                                    <td class="px-8 py-6">
                                        <div class="text-xs font-bold text-crextio-muted uppercase">{{ $penalty->issuer->name }}</div>
                                    </td>
                                    <td class="px-8 py-6 text-right">
                                        @if(!$penalty->isPaid())
                                            <a href="{{ route('penalties.pay', $penalty) }}" class="inline-flex items-center px-4 py-2 bg-gradient-to-r from-crextio-accent to-crextio-text text-white text-[10px] font-black rounded-lg hover:shadow-glow transition-all uppercase tracking-widest">
                                                Record Payment
                                            </a>
                                        @else
                                            <div class="text-[10px] text-emerald-600 font-black uppercase tracking-widest">
                                                Completed at {{ $penalty->paid_at->format('H:i') }}
                                            </div>
                                        @endif
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="6" class="px-8 py-12 text-center">
                                        <div class="flex flex-col items-center">
                                            <div class="p-4 bg-gray-100 rounded-full mb-4">
                                                <svg class="w-8 h-8 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                                </svg>
                                            </div>
                                            <p class="text-crextio-muted font-bold uppercase text-xs tracking-widest">No penalties found in the registry</p>
                                        </div>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                @if($penalties->hasPages())
                    <div class="px-8 py-6 bg-white/30 border-t border-gray-100/50">
                        {{ $penalties->links() }}
                    </div>
                @endif
            </div>
        </div>
    </div>
</x-app-layout>
