@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-8">
    <h1 class="text-2xl font-bold mb-6">Messages with {{ $member->name }}</h1>

    <div class="bg-white p-6 rounded-lg shadow-md max-h-96 overflow-y-auto">
        @forelse($messages as $message)
            <div class="mb-4 {{ $message->sender_id == auth()->id() ? 'text-right' : 'text-left' }}">
                <div class="inline-block bg-gray-200 p-3 rounded-lg max-w-xs">
                    <p>{{ $message->message }}</p>
                    <small class="text-gray-500">{{ $message->sent_at->format('M d, Y H:i') }}</small>
                </div>
            </div>
        @empty
            <p class="text-gray-500">No messages yet.</p>
        @endforelse
    </div>

    <form action="{{ route('messages.store') }}" method="POST" class="mt-6 bg-white p-6 rounded-lg shadow-md">
        @csrf
        <input type="hidden" name="receiver_id" value="{{ $member->id }}">

        <div class="mb-4">
            <label for="message" class="block text-sm font-medium text-gray-700">Reply</label>
            <textarea name="message" id="message" rows="3" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500" placeholder="Enter your reply"></textarea>
            @error('message')
                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
            @enderror
        </div>

        <button type="submit" class="bg-indigo-600 text-white px-4 py-2 rounded-md hover:bg-indigo-700">Send Reply</button>
    </form>
</div>
@endsection
