<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Unassigned Members') }}
        </h2>

        <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <!-- Header Section -->
            <div class="mb-8 flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4 animate-fade-in">
                <div>
                    <h1 class="text-3xl font-bold text-crextio-text font-display">Unassigned Members</h1>
                    <p class="text-gray-600 mt-1">New users awaiting leader assignment</p>
                </div>
                <a href="{{ route('members.index') }}" class="inline-flex items-center px-6 py-3 bg-gray-200 hover:bg-gray-300 text-gray-700 font-medium rounded-lg transition-all duration-300">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                    </svg>
                    Back to All Members
                </a>
            </div>

            @if(session('success'))
                <div class="mb-6 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded-lg">
                    {{ session('success') }}
                </div>
            @endif

            <!-- Search Section -->
            <div class="bg-white rounded-xl shadow-soft p-6 mb-6 animate-slide-up">
                <form method="GET" action="{{ route('members.unassigned') }}" class="flex flex-col md:flex-row gap-4">
                    <div class="flex-1 relative">
                        <svg class="absolute left-3 top-1/2 -translate-y-1/2 w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                        </svg>
                        <input type="text" name="search" value="{{ request('search') }}" placeholder="Search by member name..." 
                               class="w-full pl-10 pr-4 py-3 border border-gray-200 rounded-lg focus:ring-2 focus:ring-crextio-accent focus:border-transparent transition-all">
                    </div>
                    <button type="submit" class="px-6 py-3 bg-crextio-text hover:bg-gray-800 text-white font-medium rounded-lg transition-all duration-300 shadow-soft hover:shadow-md">
                        Search
                    </button>
                    @if(request('search'))
                        <a href="{{ route('members.unassigned') }}" class="px-6 py-3 bg-gray-100 hover:bg-gray-200 text-gray-700 font-medium rounded-lg transition-all duration-300">
                            Clear
                        </a>
                    @endif
                </form>
            </div>

            <!-- Unassigned Members Table -->
            <div class="bg-white rounded-xl shadow-soft overflow-hidden animate-slide-up" style="animation-delay: 0.1s;">
                @if($unassignedMembers->count() > 0)
                    <div class="overflow-x-auto">
                        <table class="w-full">
                            <thead class="bg-amber-50 border-b border-amber-200">
                                <tr>
                                    <th class="px-6 py-4 text-left text-xs font-semibold text-amber-800 uppercase tracking-wider">Member</th>
                                    <th class="px-6 py-4 text-left text-xs font-semibold text-amber-800 uppercase tracking-wider">Phone</th>
                                    <th class="px-6 py-4 text-left text-xs font-semibold text-amber-800 uppercase tracking-wider">Joined</th>
                                    <th class="px-6 py-4 text-left text-xs font-semibold text-amber-800 uppercase tracking-wider">Assign to Leader</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-100">
                                @foreach($unassignedMembers as $member)
                                <tr class="hover:bg-amber-50/50 transition-colors duration-200">
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="flex items-center">
                                            <div class="h-10 w-10 flex-shrink-0 rounded-full bg-amber-400 flex items-center justify-center">
                                                <span class="text-sm font-medium text-gray-900">{{ substr($member->name, 0, 1) }}</span>
                                            </div>
                                            <div class="ml-4">
                                                <div class="text-sm font-medium text-gray-900">{{ $member->name }}</div>
                                                <div class="text-xs text-amber-600 font-medium">Unassigned</div>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-sm text-gray-900">{{ $member->phone }}</div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <span class="text-sm text-gray-600">{{ $member->join_date ? $member->join_date->format('M d, Y') : 'N/A' }}</span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <form action="{{ route('members.assign-leader', $member) }}" method="POST" class="flex items-center gap-2">
                                            @csrf
                                            <select name="leader_id" required class="text-sm border border-gray-200 rounded-lg px-3 py-2 focus:ring-2 focus:ring-crextio-accent focus:border-transparent">
                                                <option value="">Select Leader</option>
                                                @foreach($leaders as $leader)
                                                    <option value="{{ $leader->id }}">{{ $leader->name }} ({{ $leader->region ?? 'No Region' }})</option>
                                                @endforeach
                                            </select>
                                            <button type="submit" class="px-4 py-2 bg-crextio-accent hover:bg-yellow-500 text-gray-900 font-medium rounded-lg transition-all duration-300 text-sm">
                                                Assign
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="px-6 py-4 bg-gray-50 border-t border-gray-200">
                        {{ $unassignedMembers->links() }}
                    </div>
                @else
                    <!-- Empty State -->
                    <div class="text-center py-16">
                        <svg class="mx-auto h-16 w-16 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        <h3 class="mt-4 text-lg font-medium text-gray-900">All members are assigned!</h3>
                        <p class="mt-2 text-sm text-gray-500">
                            There are no unassigned members at this time.
                        </p>
                    </div>
                @endif
            </div>
        </div>
    </div>
    </x-slot>
</x-app-layout>
