<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('My Financial Dashboard') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <!-- Welcome Header -->
            <div class="mb-8 animate-fade-in">
                <h1 class="text-3xl font-bold text-crextio-text font-display">Welcome, {{ auth()->user()->name }}!</h1>
                <p class="text-gray-600 mt-1">Track your contributions and loans in one place</p>
            </div>

            <!-- Statistics Cards -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
                <!-- Total Contributions -->
                <div class="bg-white rounded-xl shadow-soft p-6 animate-slide-up">
                    <div class="flex items-center justify-between mb-2">
                        <div class="p-3 bg-blue-100 rounded-lg">
                            <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                            </svg>
                        </div>
                    </div>
                    <p class="text-sm text-gray-600">Total Contributions</p>
                    <p class="text-2xl font-bold text-gray-900">TZS {{ number_format($totalContributions, 0) }}</p>
                    <p class="text-xs text-gray-500 mt-1">All time</p>
                </div>

                <!-- This Month -->
                <div class="bg-white rounded-xl shadow-soft p-6 animate-slide-up" style="animation-delay: 0.1s;">
                    <div class="flex items-center justify-between mb-2">
                        <div class="p-3 bg-green-100 rounded-lg">
                            <svg class="w-6 h-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                        </div>
                    </div>
                    <p class="text-sm text-gray-600">This Month</p>
                    <p class="text-2xl font-bold text-gray-900">TZS {{ number_format($thisMonthContributions, 0) }}</p>
                    <p class="text-xs text-gray-500 mt-1">{{ now()->format('F Y') }}</p>
                </div>

                <!-- Active Loans -->
                <div class="bg-white rounded-xl shadow-soft p-6 animate-slide-up" style="animation-delay: 0.2s;">
                    <div class="flex items-center justify-between mb-2">
                        <div class="p-3 bg-purple-100 rounded-lg">
                            <svg class="w-6 h-6 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path>
                            </svg>
                        </div>
                    </div>
                    <p class="text-sm text-gray-600">Total Loans</p>
                    <p class="text-2xl font-bold text-gray-900">TZS {{ number_format($totalLoanAmount, 0) }}</p>
                    <p class="text-xs text-gray-500 mt-1">{{ $activeLoans }} active</p>
                </div>
            </div>

            <!-- Contribution Trend Chart -->
            <div class="bg-white rounded-xl shadow-soft p-6 mb-8 animate-slide-up" style="animation-delay: 0.3s;">
                <h3 class="text-lg font-bold text-gray-900 mb-4">My Contribution Trend (Last 6 Months)</h3>
                <div class="h-64">
                    <canvas id="memberContributionsChart"></canvas>
                </div>
            </div>

            <!-- Recent Activity Grid -->
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-8">
                <!-- Recent Contributions -->
                <div class="bg-white rounded-xl shadow-soft p-6 animate-slide-up" style="animation-delay: 0.4s;">
                    <div class="flex items-center justify-between mb-4">
                        <h3 class="text-lg font-bold text-gray-900">Recent Contributions</h3>
                        <a href="{{ route('member.contributions') }}" class="text-sm text-blue-600 hover:text-blue-800">View All →</a>
                    </div>
                    <div class="space-y-3">
                        @forelse($contributions as $contribution)
                        <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                            <div>
                                <p class="text-sm font-semibold text-gray-900">{{ $contribution->contribution_date->format('M d, Y') }}</p>
                                <p class="text-xs text-gray-500">{{ ucfirst(str_replace('_', ' ', $contribution->payment_method)) }}</p>
                            </div>
                            <p class="text-sm font-bold text-gray-900">TZS {{ number_format($contribution->amount, 0) }}</p>
                        </div>
                        @empty
                        <p class="text-sm text-gray-500 text-center py-4">No contributions yet</p>
                        @endforelse
                    </div>
                </div>

                <!-- My Loans -->
                <div class="bg-white rounded-xl shadow-soft p-6 animate-slide-up" style="animation-delay: 0.5s;">
                    <div class="flex items-center justify-between mb-4">
                        <h3 class="text-lg font-bold text-gray-900">My Loans</h3>
                        <a href="{{ route('loans.index') }}" class="text-sm text-blue-600 hover:text-blue-800">View All →</a>
                    </div>
                    <div class="space-y-3">
                        @forelse($loans as $loan)
                        <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                            <div>
                                <p class="text-sm font-semibold text-gray-900">TZS {{ number_format($loan->amount, 0) }}</p>
                                <p class="text-xs text-gray-500">{{ $loan->created_at->format('M d, Y') }}</p>
                            </div>
                            <span class="text-xs px-2 py-1 rounded-full {{ $loan->getStatusBadgeColor() }}">
                                {{ $loan->getStatusText() }}
                            </span>
                        </div>
                        @empty
                        <p class="text-sm text-gray-500 text-center py-4">No loan applications</p>
                        @endforelse
                    </div>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <a href="{{ route('contributions.index') }}" class="bg-white rounded-xl shadow-soft p-6 hover:shadow-md transition-all animate-slide-up" style="animation-delay: 0.6s;">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-blue-100 rounded-lg">
                            <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                            </svg>
                        </div>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900">View All Contributions</h3>
                    <p class="text-sm text-gray-500 mt-1">Complete contribution history</p>
                </a>

                <a href="{{ route('loans.create') }}" class="bg-white rounded-xl shadow-soft p-6 hover:shadow-md transition-all animate-slide-up" style="animation-delay: 0.7s;">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-purple-100 rounded-lg">
                            <svg class="w-6 h-6 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                            </svg>
                        </div>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900">Request Loan</h3>
                    <p class="text-sm text-gray-500 mt-1">Submit new loan application</p>
                </a>

                <a href="{{ route('member.statement') }}" class="bg-white rounded-xl shadow-soft p-6 hover:shadow-md transition-all animate-slide-up" style="animation-delay: 0.8s;">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-green-100 rounded-lg">
                            <svg class="w-6 h-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                            </svg>
                        </div>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900">Download Statement</h3>
                    <p class="text-sm text-gray-500 mt-1">Get your financial statement (PDF)</p>
                </a>
            </div>
        </div>
    </div>

    @push('scripts')
    <!-- Chart.js Library -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const ctx = document.getElementById('memberContributionsChart');
            if (ctx) {
                new Chart(ctx.getContext('2d'), {
                    type: 'line',
                    data: {
                        labels: @json(array_column($monthlyData, 'month')),
                        datasets: [{
                            label: 'Monthly Contributions (TZS)',
                            data: @json(array_column($monthlyData, 'total')),
                            borderColor: 'rgb(59, 130, 246)',
                            backgroundColor: 'rgba(59, 130, 246, 0.1)',
                            borderWidth: 3,
                            fill: true,
                            tension: 0.4,
                            pointBackgroundColor: 'rgb(59, 130, 246)',
                            pointBorderColor: '#fff',
                            pointBorderWidth: 2,
                            pointRadius: 5,
                            pointHoverRadius: 7
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        plugins: {
                            legend: {
                                display: false
                            },
                            tooltip: {
                                backgroundColor: 'rgba(0, 0, 0, 0.8)',
                                padding: 12,
                                callbacks: {
                                    label: function(context) {
                                        return 'TZS ' + context.parsed.y.toLocaleString();
                                    }
                                }
                            }
                        },
                        scales: {
                            y: {
                                beginAtZero: true,
                                ticks: {
                                    callback: function(value) {
                                        return 'TZS ' + (value / 1000) + 'K';
                                    }
                                },
                                grid: {
                                    color: 'rgba(0, 0, 0, 0.05)'
                                }
                            },
                            x: {
                                grid: {
                                    display: false
                                }
                            }
                        }
                    }
                });
            }
        });
    </script>
    @endpush
</x-app-layout>
