<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Loan Details') }}
        </h2>
        <div class="py-10">
        <div class="max-w-5xl mx-auto sm:px-6 lg:px-1">
            <!-- Back Button -->
            <div class="mb-6 animate-fade-in">
                <a href="{{ auth()->user()->role === 'top-leader' ? route('loans.pending') : route('loans.index') }}" class="inline-flex items-center text-gray-600 hover:text-gray-900 transition-colors">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                    </svg>
                    Back to {{ auth()->user()->role === 'top-leader' ? 'Pending Loans' : 'My Loans' }}
                </a>
            </div>

            <!-- Success/Error Messages -->
            @if(session('success'))
                <div class="mb-6 bg-green-50 border-l-4 border-green-500 p-4 rounded-lg animate-slide-up">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 text-green-500 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                        </svg>
                        <p class="text-green-700 font-medium">{{ session('success') }}</p>
                    </div>
                </div>
            @endif

            @if(session('error'))
                <div class="mb-6 bg-red-50 border-l-4 border-red-500 p-4 rounded-lg animate-slide-up">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 text-red-500 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"></path>
                        </svg>
                        <p class="text-red-700 font-medium">{{ session('error') }}</p>
                    </div>
                </div>
            @endif

            <!-- Loan Details Card -->
            <div class="bg-white rounded-xl shadow-soft p-6 mb-8 animate-slide-up">
                <div class="flex items-center justify-between mb-6">
                    <h1 class="text-2xl font-bold text-crextio-text font-display">Loan Application</h1>
                    <span class="px-4 py-2 text-sm font-semibold rounded-full {{ $loan->getStatusBadgeColor() }}">
                        {{ $loan->getStatusText() }}
                    </span>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Amount -->
                    <div class="flex items-center p-4 bg-purple-50 rounded-lg">
                        <div class="p-3 bg-purple-100 rounded-lg mr-4">
                            <svg class="w-6 h-6 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                            </svg>
                        </div>
                        <div>
                            <p class="text-sm font-medium text-gray-600">Loan Amount</p>
                            <p class="text-xl font-bold text-gray-900">TZS {{ number_format($loan->amount) }}</p>
                        </div>
                    </div>

                    <!-- Purpose -->
                    <div class="flex items-center p-4 bg-blue-50 rounded-lg">
                        <div class="p-3 bg-blue-100 rounded-lg mr-4">
                            <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                            </svg>
                        </div>
                        <div class="flex-1">
                            <p class="text-sm font-medium text-gray-600">Purpose</p>
                            <p class="text-base font-semibold text-gray-900">{{ $loan->purpose }}</p>
                        </div>
                    </div>

                    @if(auth()->user()->role !== 'user')
                        <!-- Member Info (for leaders/top-leaders) -->
                        <div class="md:col-span-2 flex items-center p-4 bg-gray-50 rounded-lg">
                            <div class="h-12 w-12 bg-crextio-accent rounded-full flex items-center justify-center mr-4">
                                <span class="text-lg font-bold text-gray-900">{{ substr($loan->user->name, 0, 1) }}</span>
                            </div>
                            <div>
                                <p class="text-sm font-medium text-gray-600">Member</p>
                                <p class="text-base font-semibold text-gray-900">{{ $loan->user->name }}</p>
                                <p class="text-sm text-gray-500">{{ $loan->user->email }}</p>
                            </div>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Timeline -->
            <div class="bg-white rounded-xl shadow-soft p-6 mb-8 animate-slide-up" style="animation-delay: 0.1s;">
                <h2 class="text-xl font-bold text-gray-900 mb-6 font-display">Loan Progress Timeline</h2>
                
                <div class="relative">
                    @php
                        $steps = [
                            [
                                'title' => 'Loan Requested',
                                'completed' => true,
                                'date' => $loan->created_at,
                                'icon' => 'M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z',
                                'color' => 'blue',
                                'description' => 'Application submitted'
                            ],
                            [
                                'title' => 'Under Review',
                                'completed' => !$loan->isPending(),
                                'date' => $loan->approved_at,
                                'icon' => 'M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2',
                                'color' => 'yellow',
                                'description' => $loan->isPending() ? 'Awaiting approval' : 'Review completed'
                            ],
                            [
                                'title' => $loan->isApproved() ? 'Approved' : ($loan->isRejected() ? 'Rejected' : 'Pending Approval'),
                                'completed' => $loan->isApproved() || $loan->isRejected(),
                                'date' => $loan->approved_at,
                                'icon' => $loan->isApproved() ? 'M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z' : 'M10 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2m7-2a9 9 0 11-18 0 9 9 0 0118 0z',
                                'color' => $loan->isApproved() ? 'green' : ($loan->isRejected() ? 'red' : 'gray'),
                                'description' => $loan->approver ? 'By ' . $loan->approver->name : ($loan->isRejected() ? 'Application rejected' : 'Awaiting decision'),
                                'show' => true
                            ],
                            [
                                'title' => 'Disbursed',
                                'completed' => $loan->isPaid(),
                                'date' => $loan->disbursed_at,
                                'icon' => 'M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z',
                                'color' => 'purple',
                                'description' => $loan->disburser ? 'By ' . $loan->disburser->name : 'Pending disbursement',
                                'show' => $loan->isApproved()
                            ],
                        ];
                    @endphp

                    @foreach($steps as $index => $step)
                        @if($step['show'] ?? true)
                        <div class="flex items-start mb-8 last:mb-0">
                            <!-- Circle & Line -->
                            <div class="flex flex-col items-center mr-4">
                                <div class="w-12 h-12 rounded-full flex items-center justify-center {{ $step['completed'] ? 'bg-' . $step['color'] . '-500' : 'bg-gray-300' }} shadow-md">
                                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="{{ $step['icon'] }}"></path>
                                    </svg>
                                </div>
                                @if(!$loop->last && ($steps[$loop->iteration]['show'] ?? true))
                                    <div class="w-1 h-16 {{ $step['completed'] ? 'bg-' . $step['color'] . '-500' : 'bg-gray-300' }}"></div>
                                @endif
                            </div>

                            <!-- Content -->
                            <div class="flex-1 {{ $step['completed'] ? '' : 'opacity-50' }}">
                                <h3 class="text-lg font-semibold text-gray-900 mb-1">{{ $step['title'] }}</h3>
                                <p class="text-sm text-gray-600 mb-1">{{ $step['description'] }}</p>
                                @if($step['date'])
                                    <p class="text-xs text-gray-500">{{ $step['date']->format('F d, Y \a\t h:i A') }}</p>
                                @endif
                            </div>
                        </div>
                        @endif
                    @endforeach
                </div>
            </div>

            <!-- Payment Details (if disbursed) -->
            @if($loan->isPaid())
            <div class="bg-white rounded-xl shadow-soft p-6 mb-8 animate-slide-up" style="animation-delay: 0.2s;">
                <h2 class="text-xl font-bold text-gray-900 mb-6 font-display">Payment Details</h2>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <p class="text-sm font-medium text-gray-600 mb-1">Payment Date</p>
                        <p class="text-base font-semibold text-gray-900">{{ $loan->payment_date->format('F d, Y') }}</p>
                    </div>
                    <div>
                        <p class="text-sm font-medium text-gray-600 mb-1">Amount Disbursed</p>
                        <p class="text-base font-semibold text-gray-900">TZS {{ number_format($loan->payment_amount) }}</p>
                    </div>
                    <div>
                        <p class="text-sm font-medium text-gray-600 mb-1">Payment Method</p>
                        <p class="text-base font-semibold text-gray-900">{{ ucfirst(str_replace('_', ' ', $loan->payment_method)) }}</p>
                    </div>
                    <div>
                        <p class="text-sm font-medium text-gray-600 mb-1">Disbursed By</p>
                        <p class="text-base font-semibold text-gray-900">{{ $loan->disburser->name ?? 'N/A' }}</p>
                    </div>
                    @if($loan->notes)
                    <div class="md:col-span-2">
                        <p class="text-sm font-medium text-gray-600 mb-1">Notes</p>
                        <p class="text-base text-gray-900 bg-gray-50 p-3 rounded-lg">{{ $loan->notes }}</p>
                    </div>
                    @endif
                </div>
            </div>
            @endif

            <!-- Actions for Top-Leaders -->
                @if(auth()->user()->role === 'leader' && $loan->isPendingLeaderReview() || in_array(auth()->user()->role, ['top-leader', 'admin']) && $loan->isPendingTopLeaderReview())
                    <!-- Approve/Reject Actions -->
                    <div class="bg-white rounded-xl shadow-soft p-6 animate-slide-up" style="animation-delay: 0.3s;">
                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Review Loan Request</h3>
                        <div class="flex gap-4">
                            <form method="POST" action="{{ route('loans.confirm', $loan) }}" class="flex-1" onsubmit="return confirm('Are you sure you want to approve this loan?');">
                                @csrf
                                @method('PATCH')
                                <input type="hidden" name="action" value="approve">
                                <button type="submit" class="w-full px-6 py-3 bg-green-500 hover:bg-green-600 text-white font-medium rounded-lg transition-all duration-300 shadow-soft hover:shadow-md">
                                    Approve Loan
                                </button>
                            </form>
                            <form method="POST" action="{{ route('loans.confirm', $loan) }}" class="flex-1" onsubmit="return confirm('Are you sure you want to reject this loan?');">
                                @csrf
                                @method('PATCH')
                                <input type="hidden" name="action" value="reject">
                                <button type="submit" class="w-full px-6 py-3 bg-red-500 hover:bg-red-600 text-white font-medium rounded-lg transition-all duration-300 shadow-soft hover:shadow-md">
                                    Reject Loan
                                </button>
                            </form>
                        </div>
                    </div>
                @elseif(in_array(auth()->user()->role, ['top-leader', 'admin', 'treasurer', 'regional-treasurer']) && $loan->isApproved() && !$loan->isPaid())
                    <!-- Mark as Paid Form -->
                    <div class="bg-white rounded-xl shadow-soft p-6 animate-slide-up" style="animation-delay: 0.3s;">
                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Mark as Disbursed</h3>
                        <form method="POST" action="{{ route('loans.markAsPaid', $loan) }}">
                            @csrf
                            @method('PATCH')
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">Payment Date</label>
                                    <input type="date" name="payment_date" value="{{ date('Y-m-d') }}" required
                                           class="w-full px-4 py-3 border border-gray-200 rounded-lg focus:ring-2 focus:ring-crextio-accent focus:border-transparent transition-all">
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">Amount Disbursed</label>
                                    <input type="number" name="payment_amount" step="0.01" value="{{ $loan->amount }}" required
                                           class="w-full px-4 py-3 border border-gray-200 rounded-lg focus:ring-2 focus:ring-crextio-accent focus:border-transparent transition-all">
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">Payment Method</label>
                                    <select name="payment_method" required
                                            class="w-full px-4 py-3 border border-gray-200 rounded-lg focus:ring-2 focus:ring-crextio-accent focus:border-transparent transition-all">
                                        <option value="">Select method</option>
                                        <option value="cash">Cash</option>
                                        <option value="bank_transfer">Bank Transfer</option>
                                        <option value="mobile_money">Mobile Money</option>
                                    </select>
                                </div>
                                <div class="md:col-span-2">
                                    <label class="block text-sm font-medium text-gray-700 mb-2">Notes (Optional)</label>
                                    <textarea name="notes" rows="3" 
                                              class="w-full px-4 py-3 border border-gray-200 rounded-lg focus:ring-2 focus:ring-crextio-accent focus:border-transparent transition-all"
                                              placeholder="Add any additional notes..."></textarea>
                                </div>
                            </div>
                            
                            <button type="submit" class="w-full px-6 py-3 bg-crextio-accent hover:bg-yellow-500 text-gray-900 font-medium rounded-lg transition-all duration-300 shadow-soft hover:shadow-md">
                                Mark as Disbursed
                            </button>
                        </form>
                    </div>
                @endif
        </div>
    </div>
    </x-slot>
</x-app-layout>
