<div>
    <h3 class="text-lg font-semibold mb-4">Unreplied Messages</h3>
    @if($messages->count() > 0)
        <div class="space-y-4">
            @foreach($messages as $message)
                <div class="bg-gray-100 p-4 rounded-lg">
                    <p class="font-medium">From: {{ $message->sender->name }}</p>
                    <p>{{ $message->message }}</p>
                    <p class="text-sm text-gray-500">{{ $message->sent_at->format('M d, Y H:i') }}</p>
                    <button wire:click="markAsReplied({{ $message->id }})" class="mt-2 bg-blue-500 text-white px-3 py-1 rounded hover:bg-blue-600">Mark as Replied</button>
                </div>
            @endforeach
        </div>
    @else
        <p class="text-gray-600">No unreplied messages.</p>
    @endif
</div>
