<nav x-data="{ open: false }" class="bg-transparent pt-6 px-8 pb-2">
    <!-- Primary Navigation Menu -->
    <div class="max-w-7xl mx-auto">
        <div class="flex justify-between h-16 items-center">
            <!-- Logo -->
            <div class="shrink-0 flex items-center">
                <a href="{{ route('dashboard') }}" class="text-2xl font-bold tracking-tight text-gray-900 font-display">
                    ARISE FAMILY
                </a>
            </div>

            <!-- Navigation Links (Pills) -->
            <div class="hidden space-x-1 sm:-my-px sm:ms-10 sm:flex bg-white/50 backdrop-blur-sm rounded-full px-2 py-1.5 border border-white/60 shadow-sm">
                <x-nav-link :href="route('dashboard')" :active="request()->routeIs('dashboard')" class="rounded-full px-6 py-2 text-sm font-medium transition-all duration-300 {{ request()->routeIs('dashboard') ? 'bg-gray-900 text-white shadow-md' : 'text-gray-600 hover:bg-gray-100' }}">
                    {{ __('Dashboard') }}
                </x-nav-link>

                 @if(auth()->user()->role === 'user')
                <x-nav-link :href="route('member.dashboard')" :active="request()->routeIs('member.*')" class="rounded-full px-6 py-2 text-sm font-medium transition-all duration-300 {{ request()->routeIs('member.*') ? 'bg-gray-900 text-white shadow-md' : 'text-gray-600 hover:bg-gray-100' }}">
                    {{ __('My Dashboard') }}
                </x-nav-link>
                @endif
                
                @if(in_array(auth()->user()->role, ['leader', 'top-leader', 'admin']))
                <x-nav-link :href="route('members.index')" :active="request()->routeIs('members.*')" class="rounded-full px-6 py-2 text-sm font-medium transition-all duration-300 {{ request()->routeIs('members.*') ? 'bg-gray-900 text-white shadow-md' : 'text-gray-600 hover:bg-gray-100' }}">
                    {{ __('People') }}
                </x-nav-link>
                @endif

                @if(in_array(auth()->user()->role, ['user', 'leader', 'top-leader', 'admin', 'treasurer', 'regional-treasurer']))
                <x-nav-link :href="route('contributions.index')" :active="request()->routeIs('contributions.index')" class="rounded-full px-6 py-2 text-sm font-medium transition-all duration-300 {{ request()->routeIs('contributions.index') ? 'bg-gray-900 text-white shadow-md' : 'text-gray-600 hover:bg-gray-100' }}">
                    {{ __('Contributions') }}
                </x-nav-link>
                <x-nav-link :href="route('contributions.create')" :active="request()->routeIs('contributions.create')" class="ml-2 rounded-full px-4 py-2 text-xs font-bold transition-all duration-300 {{ request()->routeIs('contributions.create') ? 'bg-crextio-accent text-gray-900' : 'bg-gray-100 text-gray-600 hover:bg-gray-200' }}">
                    {{ __('+ Record') }}
                </x-nav-link>
                @endif

                @if(in_array(auth()->user()->role, ['user', 'leader', 'top-leader', 'admin', 'treasurer', 'regional-treasurer']))
                <x-nav-link :href="route('loans.index')" :active="request()->routeIs('loans.index') || request()->routeIs('loans.create') || request()->routeIs('loans.show')" class="rounded-full px-6 py-2 text-sm font-medium transition-all duration-300 {{ request()->routeIs('loans.index') || request()->routeIs('loans.create') || request()->routeIs('loans.show') ? 'bg-gray-900 text-white shadow-md' : 'text-gray-600 hover:bg-gray-100' }}">
                    {{ __('Loans') }}
                </x-nav-link>
                @endif

                @if(in_array(auth()->user()->role, ['leader', 'top-leader', 'admin']))
                <x-nav-link :href="route('loans.pending')" :active="request()->routeIs('loans.pending')" class="rounded-full px-6 py-2 text-sm font-medium transition-all duration-300 {{ request()->routeIs('loans.pending') ? 'bg-gray-900 text-white shadow-md' : 'text-gray-600 hover:bg-gray-100' }}">
                    {{ __('Pending Loans') }}
                </x-nav-link>
                @endif

                @if(in_array(auth()->user()->role, ['leader', 'top-leader', 'admin', 'treasurer', 'regional-treasurer']))
                <x-nav-link :href="route('penalties.index')" :active="request()->routeIs('penalties.*')" class="rounded-full px-6 py-2 text-sm font-medium transition-all duration-300 {{ request()->routeIs('penalties.*') ? 'bg-gray-900 text-white shadow-md' : 'text-gray-600 hover:bg-gray-100' }}">
                    {{ __('Penalties') }}
                </x-nav-link>
                @endif

                @if(in_array(auth()->user()->role, ['top-leader', 'admin']))
                <x-nav-link :href="route('regions.index')" :active="request()->routeIs('regions.*')" class="rounded-full px-6 py-2 text-sm font-medium transition-all duration-300 {{ request()->routeIs('regions.*') ? 'bg-gray-900 text-white shadow-md' : 'text-gray-600 hover:bg-gray-100' }}">
                    {{ __('Regions') }}
                </x-nav-link>
                @endif

                @if(in_array(auth()->user()->role, ['treasurer', 'top-leader', 'admin', 'regional-treasurer']))
                <x-nav-link :href="route('treasurer.dashboard')" :active="request()->routeIs('treasurer.*')" class="rounded-full px-6 py-2 text-sm font-medium transition-all duration-300 {{ request()->routeIs('treasurer.*') ? 'bg-gray-900 text-white shadow-md' : 'text-gray-600 hover:bg-gray-100' }}">
                    {{ __('Treasurer') }}
                </x-nav-link>
                @endif
                
               
                
                @if(in_array(auth()->user()->role, ['top-leader', 'admin']))
                <x-nav-link :href="route('users.index')" :active="request()->routeIs('users.*')" class="rounded-full px-6 py-2 text-sm font-medium transition-all duration-300 {{ request()->routeIs('users.*') ? 'bg-gray-900 text-white shadow-md' : 'text-gray-600 hover:bg-gray-100' }}">
                    {{ __('Users') }}
                </x-nav-link>
                @endif
            </div>

            <!-- Settings & Profile -->
            <div class="hidden sm:flex sm:items-center sm:ms-6 space-x-3">
                @if(in_array(auth()->user()->role, ['top-leader', 'admin']))
                    @php
                        $availableRegions = \App\Models\Region::orderBy('name')->pluck('name');
                    @endphp
                    <div class="relative">
                        <x-dropdown align="right" width="48">
                            <x-slot name="trigger">
                                <button class="flex items-center px-3 py-2 border border-gray-300 text-sm leading-4 font-medium rounded-full text-gray-500 bg-white hover:text-gray-700 focus:outline-none transition ease-in-out duration-150 shadow-sm">
                                    <svg class="w-4 h-4 mr-2 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path></svg>
                                    <div>{{ session('selected_region') ?? 'All Regions' }}</div>
                                    <div class="ms-1">
                                        <svg class="fill-current h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                                        </svg>
                                    </div>
                                </button>
                            </x-slot>

                            <x-slot name="content">
                                <form method="POST" action="{{ route('admin.select-region') }}">
                                    @csrf
                                    <x-dropdown-link href="#" onclick="event.preventDefault(); this.closest('form').submit();">
                                        {{ __('All Regions') }}
                                        <input type="hidden" name="region" value="">
                                    </x-dropdown-link>
                                </form>
                                <div class="border-t border-gray-100"></div>
                                @foreach($availableRegions as $regionName)
                                    <form method="POST" action="{{ route('admin.select-region') }}">
                                        @csrf
                                        <input type="hidden" name="region" value="{{ $regionName }}">
                                        <x-dropdown-link href="#" onclick="event.preventDefault(); this.closest('form').submit();">
                                            {{ $regionName }}
                                        </x-dropdown-link>
                                    </form>
                                @endforeach
                            </x-slot>
                        </x-dropdown>
                    </div>
                @endif

                <button 
                    x-data="{ 
                        darkMode: localStorage.theme === 'dark' || (!('theme' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches),
                        toggle() {
                            this.darkMode = !this.darkMode;
                            if (this.darkMode) {
                                document.documentElement.classList.add('dark');
                                localStorage.theme = 'dark';
                            } else {
                                document.documentElement.classList.remove('dark');
                                localStorage.theme = 'light';
                            }
                        }
                    }"
                    @click="toggle()"
                    class="p-2 rounded-full bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700 text-gray-500 dark:text-gray-400 hover:text-gray-700 dark:hover:text-gray-200 hover:bg-gray-50 dark:hover:bg-gray-700 transition shadow-sm"
                    title="Toggle Dark/Light Mode"
                >
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path></svg>
                </button>
                
                <x-dropdown align="right" width="48">
                    <x-slot name="trigger">
                        <button class="flex items-center p-1 pr-3 rounded-full bg-white border border-gray-200 hover:bg-gray-50 transition shadow-sm">
                            <div class="h-8 w-8 rounded-full overflow-hidden shadow-sm mr-2 flex items-center justify-center bg-crextio-accent">
                                @if(Auth::user()->profile_picture)
                                    <img src="{{ Storage::url(Auth::user()->profile_picture) }}" class="h-full w-full object-cover">
                                @else
                                    <span class="text-gray-900 font-black text-sm">{{ substr(Auth::user()->name, 0, 1) }}</span>
                                @endif
                            </div>
                            <div class="text-sm font-medium text-gray-700">{{ Auth::user()->name }}</div>
                            <svg class="ml-2 h-4 w-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
                        </button>
                    </x-slot>

                    <x-slot name="content">
                        <x-dropdown-link :href="route('profile.edit')">
                            {{ __('Profile Settings') }}
                        </x-dropdown-link>
                        <div class="border-t border-gray-100"></div>
                        <form method="POST" action="{{ route('logout') }}">
                            @csrf
                            <x-dropdown-link :href="route('logout')" onclick="event.preventDefault(); this.closest('form').submit();">
                                {{ __('Log Out') }}
                            </x-dropdown-link>
                        </form>
                    </x-slot>
                </x-dropdown>
            </div>

            <!-- Hamburger -->
            <div class="-me-2 flex items-center sm:hidden">
                <button @click="open = ! open" class="inline-flex items-center justify-center p-2 rounded-md text-gray-400 hover:text-gray-500 hover:bg-gray-100 focus:outline-none transition duration-150 ease-in-out">
                    <svg class="h-6 w-6" stroke="currentColor" fill="none" viewBox="0 0 24 24">
                        <path :class="{'hidden': open, 'inline-flex': ! open }" class="inline-flex" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        <path :class="{'hidden': ! open, 'inline-flex': open }" class="hidden" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
        </div>
    </div>

    <!-- Responsive Navigation Menu -->
    <div :class="{'block': open, 'hidden': ! open}" class="hidden sm:hidden bg-white border-t border-gray-200">
        <div class="pt-2 pb-3 space-y-1">
            <x-responsive-nav-link :href="route('dashboard')" :active="request()->routeIs('dashboard')">
                {{ __('Dashboard') }}
            </x-responsive-nav-link>

            @if(auth()->user()->role === 'user')
            <x-responsive-nav-link :href="route('member.dashboard')" :active="request()->routeIs('member.*')">
                {{ __('My Dashboard') }}
            </x-responsive-nav-link>
            @endif
            
            @if(in_array(auth()->user()->role, ['leader', 'top-leader', 'admin']))
            <x-responsive-nav-link :href="route('members.index')" :active="request()->routeIs('members.*')">
                {{ __('People') }}
            </x-responsive-nav-link>
            @endif

            @if(in_array(auth()->user()->role, ['user', 'leader', 'top-leader', 'admin', 'treasurer', 'regional-treasurer']))
            <x-responsive-nav-link :href="route('contributions.index')" :active="request()->routeIs('contributions.index')">
                {{ __('Contributions') }}
            </x-responsive-nav-link>
            <x-responsive-nav-link :href="route('contributions.create')" :active="request()->routeIs('contributions.create')">
                {{ __('+ Record') }}
            </x-responsive-nav-link>
            @endif

            @if(in_array(auth()->user()->role, ['user', 'leader', 'top-leader', 'admin', 'treasurer', 'regional-treasurer']))
            <x-responsive-nav-link :href="route('loans.index')" :active="request()->routeIs('loans.*')">
                {{ __('Loans') }}
            </x-responsive-nav-link>
            @endif

            @if(in_array(auth()->user()->role, ['leader', 'top-leader', 'admin']))
            <x-responsive-nav-link :href="route('loans.pending')" :active="request()->routeIs('loans.pending')">
                {{ __('Pending Loans') }}
            </x-responsive-nav-link>
            @endif

            @if(in_array(auth()->user()->role, ['leader', 'top-leader', 'admin', 'treasurer', 'regional-treasurer']))
            <x-responsive-nav-link :href="route('penalties.index')" :active="request()->routeIs('penalties.*')">
                {{ __('Penalties') }}
            </x-responsive-nav-link>
            @endif

            @if(in_array(auth()->user()->role, ['top-leader', 'admin']))
            <x-responsive-nav-link :href="route('regions.index')" :active="request()->routeIs('regions.*')">
                {{ __('Regions') }}
            </x-responsive-nav-link>
            <x-responsive-nav-link :href="route('users.index')" :active="request()->routeIs('users.*')">
                {{ __('Users') }}
            </x-responsive-nav-link>
            @endif

            @if(in_array(auth()->user()->role, ['treasurer', 'top-leader', 'admin', 'regional-treasurer']))
            <x-responsive-nav-link :href="route('treasurer.dashboard')" :active="request()->routeIs('treasurer.*')">
                {{ __('Treasurer') }}
            </x-responsive-nav-link>
            @endif
        </div>
        <div class="pt-4 pb-1 border-t border-gray-200">
            <div class="px-4">
                <div class="font-medium text-base text-gray-800">{{ Auth::user()->name }}</div>
                <div class="font-medium text-sm text-gray-500">{{ Auth::user()->email }}</div>
            </div>
            <div class="mt-3 space-y-1">
                <x-responsive-nav-link :href="route('profile.edit')">
                    {{ __('Profile Settings') }}
                </x-responsive-nav-link>
                <form method="POST" action="{{ route('logout') }}">
                    @csrf
                    <x-responsive-nav-link :href="route('logout')" onclick="event.preventDefault(); this.closest('form').submit();">
                        {{ __('Log Out') }}
                    </x-responsive-nav-link>
                </form>
            </div>
        </div>
    </div>
</nav>
