<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=5, user-scalable=yes">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ config('app.name', 'Laravel') }}</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Scripts -->
        @vite(['resources/css/app.css', 'resources/js/app.js'])
    </head>
    <body class="font-sans text-gray-100 antialiased bg-amu-bg">
        <div class="min-h-screen flex">
            <!-- Left Side: Image/Brand -->
            <div class="hidden lg:flex lg:w-1/2 relative overflow-hidden">
                <img src="https://images.unsplash.com/photo-1618005182384-a83a8bd57fbe?ixlib=rb-1.2.1&auto=format&fit=crop&w=1350&q=80" class="absolute inset-0 w-full h-full object-cover" alt="Background">
                <div class="absolute inset-0 bg-amu-bg/40 backdrop-blur-[2px]"></div>
                <div class="relative z-10 p-12 flex flex-col justify-between h-full text-white">
                    <div>
                        <x-application-logo class="w-16 h-16 fill-current" />
                    </div>
                    <div>
                        <h1 class="text-5xl font-bold mb-6 font-display leading-tight">Track your saving,<br>Invest better</h1>
                        <div class="flex space-x-2">
                            <div class="w-8 h-1 bg-white rounded-full"></div>
                            <div class="w-2 h-1 bg-white/50 rounded-full"></div>
                            <div class="w-2 h-1 bg-white/50 rounded-full"></div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Right Side: Form -->
            <div class="w-full lg:w-1/2 flex items-center justify-center p-8 bg-amu-bg">
                <div class="w-full max-w-md">
                    {{ $slot }}
                </div>
            </div>
        </div>
    </body>
</html>
