<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('User Dashboard') }}
        </h2>
        <div class="py-10">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-1">
            <!-- Welcome Header -->
            <div class="mb-8 animate-fade-in">
                <h1 class="text-3xl font-bold text-crextio-text font-display">Welcome back, {{ Auth::user()->name }}!</h1>
                <p class="text-gray-600 mt-1">Here's your personal dashboard overview</p>
            </div>

            <!-- Key Metrics Grid -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-6">
                <!-- Total Members -->
                <div class="bg-white rounded-xl shadow-soft p-6 animate-slide-up hover:shadow-md transition-shadow duration-300">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-blue-100 rounded-lg">
                            <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                            </svg>
                        </div>
                        <span class="text-xs font-medium text-blue-600 bg-blue-100 px-2 py-1 rounded-full">Community</span>
                    </div>
                    <h3 class="text-sm font-medium text-gray-600 mb-1">Total Members</h3>
                    <p class="text-2xl font-bold text-gray-900">{{ number_format($totalMembers) }}</p>
                    <p class="text-xs text-gray-500 mt-2">Active members</p>
                </div>

                <!-- Total Contributions -->
                <div class="bg-white rounded-xl shadow-soft p-6 animate-slide-up hover:shadow-md transition-shadow duration-300" style="animation-delay: 0.1s;">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-green-100 rounded-lg">
                            <svg class="w-6 h-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                            </svg>
                        </div>
                        <span class="text-xs font-medium text-green-600 bg-green-100 px-2 py-1 rounded-full">Total</span>
                    </div>
                    <h3 class="text-sm font-medium text-gray-600 mb-1">Total Contributions</h3>
                    <p class="text-2xl font-bold text-gray-900">TZS {{ number_format($totalContributions) }}</p>
                    <p class="text-xs text-gray-500 mt-2">All time</p>
                </div>

                <!-- Recent Transactions -->
                <div class="bg-white rounded-xl shadow-soft p-6 animate-slide-up hover:shadow-md transition-shadow duration-300" style="animation-delay: 0.2s;">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-purple-100 rounded-lg">
                            <svg class="w-6 h-6 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                            </svg>
                        </div>
                        <span class="text-xs font-medium text-purple-600 bg-purple-100 px-2 py-1 rounded-full">Recent</span>
                    </div>
                    <h3 class="text-sm font-medium text-gray-600 mb-1">Recent Transactions</h3>
                    <p class="text-2xl font-bold text-gray-900">{{ $recentTransactions->count() }}</p>
                    <p class="text-xs text-gray-500 mt-2">Last transactions</p>
                </div>

                <!-- This Month -->
                <div class="bg-white rounded-xl shadow-soft p-6 animate-slide-up hover:shadow-md transition-shadow duration-300" style="animation-delay: 0.3s;">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-yellow-100 rounded-lg">
                            <svg class="w-6 h-6 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path>
                            </svg>
                        </div>
                        <span class="text-xs font-medium text-yellow-600 bg-yellow-100 px-2 py-1 rounded-full">{{ date('F') }}</span>
                    </div>
                    <h3 class="text-sm font-medium text-gray-600 mb-1">This Month</h3>
                    <p class="text-2xl font-bold text-gray-900">TZS {{ number_format($monthlyContributionsFull[date('n')] ?? 0) }}</p>
                    <p class="text-xs text-gray-500 mt-2">Monthly contributions</p>
                </div>
            </div>

            <!-- Loan Requests Section -->
            <div class="bg-white rounded-xl shadow-soft p-6 mb-8 animate-slide-up" style="animation-delay: 0.4s;">
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-lg font-semibold text-gray-900 font-display">My Loan Requests</h3>
                    <a href="{{ route('loans.create') }}" class="inline-flex items-center px-4 py-2 bg-crextio-accent hover:bg-yellow-500 text-gray-900 font-medium rounded-lg transition-all duration-300 shadow-soft hover:shadow-md">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                        </svg>
                        Request Loan
                    </a>
                </div>
                <div class="space-y-3">
                    @forelse($recentLoans ?? [] as $loan)
                    <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg hover:bg-gray-100 transition-colors">
                        <div class="flex items-center flex-1">
                            <div class="h-12 w-12 bg-purple-100 rounded-full flex items-center justify-center mr-4">
                                <svg class="w-6 h-6 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                                </svg>
                            </div>
                            <div class="flex-1">
                                <p class="text-sm font-semibold text-gray-900">TZS {{ number_format($loan->amount) }}</p>
                                <p class="text-xs text-gray-600">{{ $loan->purpose }}</p>
                                <p class="text-xs text-gray-400">{{ $loan->created_at->diffForHumans() }}</p>
                            </div>
                        </div>
                        <div>
                            @php
                                $statusColors = [
                                    'pending' => 'bg-yellow-100 text-yellow-800',
                                    'approved' => 'bg-green-100 text-green-800',
                                    'rejected' => 'bg-red-100 text-red-800',
                                ];
                                $color = $statusColors[$loan->status] ?? 'bg-gray-100 text-gray-800';
                            @endphp
                            <span class="px-3 py-1 text-xs font-medium rounded-full {{ $color }}">
                                {{ ucfirst($loan->status) }}
                            </span>
                        </div>
                    </div>
                    @empty
                    <div class="text-center py-8">
                        <svg class="w-12 h-12 text-gray-300 mx-auto mb-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                        <p class="text-sm text-gray-500">No loan requests yet</p>
                    </div>
                    @endforelse
                </div>
                @if(isset($recentLoans) && $recentLoans->count() > 0)
                <div class="mt-4 text-center">
                    <a href="{{ route('loans.index') }}" class="text-sm text-blue-600 hover:text-blue-800 font-medium">View All Loans →</a>
                </div>
                @endif
            </div>

            <!-- Recent Activity -->
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                <!-- Recent Members -->
                <div class="bg-white rounded-xl shadow-soft p-6 animate-slide-up" style="animation-delay: 0.5s;">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4 font-display">Recent Members</h3>
                    <div class="space-y-3">
                        @forelse($recentMembers as $member)
                        <div class="flex items-center p-3 bg-gray-50 rounded-lg hover:bg-gray-100 transition-colors">
                            <div class="h-10 w-10 bg-crextio-accent rounded-full flex items-center justify-center mr-3">
                                <span class="text-sm font-medium text-gray-900">{{ substr($member->name, 0, 1) }}</span>
                            </div>
                            <div class="flex-1 min-w-0">
                                <p class="text-sm font-medium text-gray-900 truncate">{{ $member->name }}</p>
                                <p class="text-xs text-gray-500">Joined {{ $member->created_at->diffForHumans() }}</p>
                            </div>
                        </div>
                        @empty
                        <p class="text-sm text-gray-500 text-center py-4">No recent members</p>
                        @endforelse
                    </div>
                </div>

                <!-- Recent Transactions -->
                <div class="bg-white rounded-xl shadow-soft p-6 animate-slide-up" style="animation-delay: 0.6s;">
                    <div class="flex justify-between items-center mb-4">
                        <h3 class="text-lg font-semibold text-gray-900 font-display">Recent Transactions</h3>
                        <a href="{{ route('transactions.create') }}" class="inline-flex items-center px-3 py-1.5 bg-crextio-accent hover:bg-yellow-500 text-gray-900 text-xs font-medium rounded-lg transition-all duration-300">
                            <svg class="w-3 h-3 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                            </svg>
                            Add
                        </a>
                    </div>
                    <div class="space-y-3">
                        @forelse($recentTransactions as $transaction)
                        <div class="flex items-center p-3 bg-gray-50 rounded-lg hover:bg-gray-100 transition-colors">
                            <div class="h-10 w-10 bg-green-100 rounded-full flex items-center justify-center mr-3">
                                <svg class="w-5 h-5 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                                </svg>
                            </div>
                            <div class="flex-1 min-w-0">
                                <p class="text-sm font-medium text-gray-900 truncate">{{ $transaction->member->name ?? 'Unknown' }}</p>
                                <p class="text-xs text-gray-600">{{ ucfirst($transaction->transaction_type) }} - TZS {{ number_format($transaction->amount) }}</p>
                                <p class="text-xs text-gray-400">{{ $transaction->created_at->diffForHumans() }}</p>
                            </div>
                        </div>
                        @empty
                        <p class="text-sm text-gray-500 text-center py-4">No recent transactions</p>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </div>
    </x-slot>

    
</x-app-layout>
