<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Top-Leader Dashboard') }}
        </h2>
    </x-slot>

    <div class="py-10">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-1">
            <!-- Welcome Header -->
            <div class="mb-8 flex flex-col md:flex-row justify-between items-start md:items-center gap-4 animate-fade-in">
                <div>
                    <h1 class="text-3xl font-bold text-crextio-text font-display">Welcome back, {{ Auth::user()->name }}!</h1>
                    <p class="text-gray-600 mt-1">Here's a comprehensive overview of your organization</p>
                </div>
                
                <div class="flex flex-wrap gap-3">
                    <a href="{{ route('contributions.create', ['contribution_type' => 'social']) }}" class="px-4 py-2 bg-orange-500 hover:bg-orange-600 text-white text-sm font-bold rounded-lg transition-all shadow-sm flex items-center">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                        </svg>
                        Record Social
                    </a>
                    <a href="{{ route('contributions.create', ['contribution_type' => 'share']) }}" class="px-4 py-2 bg-indigo-600 hover:bg-indigo-700 text-white text-sm font-bold rounded-lg transition-all shadow-sm flex items-center">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                        </svg>
                        Record Share
                    </a>
                </div>
            </div>

            <!-- Key Metrics Grid - Row 1 -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-6">
                <!-- Total Members -->
                <div class="bg-white rounded-xl shadow-soft p-6 animate-slide-up hover:shadow-md transition-shadow duration-300">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-blue-100 rounded-lg">
                            <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                            </svg>
                        </div>
                        <span class="text-xs font-medium text-blue-600 bg-blue-100 px-2 py-1 rounded-full">{{ $activeMembers }} Active</span>
                    </div>
                    <h3 class="text-sm font-medium text-gray-600 mb-1">Total Members</h3>
                    <p class="text-2xl font-bold text-gray-900">{{ number_format($totalMembers) }}</p>
                    <p class="text-xs text-gray-500 mt-2">+{{ $newMembersThisMonth }} this month</p>
                </div>

                <!-- Total Contributions -->
                <div class="bg-white rounded-xl shadow-soft p-6 animate-slide-up hover:shadow-md transition-shadow duration-300" style="animation-delay: 0.1s;">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-green-100 rounded-lg">
                            <svg class="w-6 h-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                            </svg>
                        </div>
                        <span class="text-xs font-medium text-green-600 bg-green-100 px-2 py-1 rounded-full">{{ $totalTransactions }} Txns</span>
                    </div>
                    <h3 class="text-sm font-medium text-gray-600 mb-1">Total Contributions</h3>
                    <p class="text-2xl font-bold text-gray-900">TZS {{ number_format($totalContributions) }}</p>
                    <p class="text-xs text-gray-500 mt-2">Avg: TZS {{ number_format($averageContribution) }}</p>
                </div>

                <!-- This Month -->
                <div class="bg-white rounded-xl shadow-soft p-6 animate-slide-up hover:shadow-md transition-shadow duration-300" style="animation-delay: 0.2s;">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-yellow-100 rounded-lg">
                            <svg class="w-6 h-6 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path>
                            </svg>
                        </div>
                        <span class="text-xs font-medium text-yellow-600 bg-yellow-100 px-2 py-1 rounded-full">{{ date('F') }}</span>
                    </div>
                    <h3 class="text-sm font-medium text-gray-600 mb-1">This Month</h3>
                    <p class="text-2xl font-bold text-gray-900">TZS {{ number_format($monthlyContributionsFull[date('n')] ?? 0) }}</p>
                    @php
                        $lastMonth = $monthlyContributionsFull[date('n') - 1] ?? 0;
                        $growth = $lastMonth > 0 ? (($monthlyContributionsFull[date('n')] - $lastMonth) / $lastMonth * 100) : 0;
                    @endphp
                    <p class="text-xs {{ $growth >= 0 ? 'text-green-600' : 'text-red-600' }} mt-2">
                        {{ $growth >= 0 ? '+' : '' }}{{ number_format($growth, 1) }}% from last month
                    </p>
                </div>

                <!-- Pending Suggestions -->
                <div class="bg-white rounded-xl shadow-soft p-6 animate-slide-up hover:shadow-md transition-shadow duration-300" style="animation-delay: 0.3s;">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-purple-100 rounded-lg">
                            <svg class="w-6 h-6 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                            </svg>
                        </div>
                        @php
                            $pendingCount = \App\Models\SuggestedMember::suggested()->count();
                        @endphp
                        @if($pendingCount > 0)
                            <span class="text-xs font-medium text-red-600 bg-red-100 px-2 py-1 rounded-full">Action Needed</span>
                        @endif
                    </div>
                    <h3 class="text-sm font-medium text-gray-600 mb-1">Pending Suggestions</h3>
                    <p class="text-2xl font-bold text-gray-900">{{ $pendingCount }}</p>
                    <p class="text-xs text-gray-500 mt-2">Awaiting review</p>
                </div>
            </div>

            <!-- Row 2: Pending Loans -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-6">
                <!-- Pending Loans -->
                <div class="bg-white rounded-xl shadow-soft p-6 animate-slide-up hover:shadow-md transition-shadow duration-300" style="animation-delay: 0.35s;">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-orange-100 rounded-lg">
                            <svg class="w-6 h-6 text-orange-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path>
                            </svg>
                        </div>
                        @if($pendingLoansCount > 0)
                            <span class="text-xs font-medium text-red-600 bg-red-100 px-2 py-1 rounded-full">Action Needed</span>
                        @endif
                    </div>
                    <h3 class="text-sm font-medium text-gray-600 mb-1">Pending Loans</h3>
                    <p class="text-2xl font-bold text-gray-900">{{ $pendingLoansCount }}</p>
                    <p class="text-xs text-gray-500 mt-2">
                        <a href="{{ route('loans.pending') }}" class="text-orange-600 hover:text-orange-800">View all →</a>
                    </p>
                </div>
            </div>

            <!--Pending Loans Section -->
            @if($pendingLoansCount > 0)
            <div class="bg-white rounded-xl shadow-soft p-6 mb-8 animate-slide-up" style="animation-delay: 0.38s;">
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-lg font-semibold text-gray-900 font-display">Pending Loan Requests</h3>
                    <a href="{{ route('loans.pending') }}" class="text-sm text-orange-600 hover:text-orange-800 font-medium">View All →</a>
                </div>
                <div class="space-y-3">
                    @foreach($pendingLoans as $loan)
                    <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg hover:bg-gray-100 transition-colors">
                        <div class="flex items-center flex-1">
                            <div class="h-10 w-10 bg-crextio-accent rounded-full flex items-center justify-center mr-3">
                                <span class="text-sm font-medium text-gray-900">{{ substr($loan->user->name, 0, 1) }}</span>
                            </div>
                            <div class="flex-1">
                                <p class="text-sm font-medium text-gray-900">{{ $loan->user->name }}</p>
                                <p class="text-xs text-gray-600">{{ $loan->purpose }}</p>
                                <p class="text-xs text-gray-400">{{ $loan->created_at->diffForHumans() }}</p>
                            </div>
                        </div>
                        <div class="flex items-center gap-3">
                            <div class="text-right mr-4">
                                <p class="text-sm font-bold text-gray-900">TZS {{ number_format($loan->amount) }}</p>
                            </div>
                            <div class="flex gap-2">
                                <form method="POST" action="{{ route('loans.confirm', $loan) }}" class="inline">
                                    @csrf
                                    @method('PATCH')
                                    <input type="hidden" name="status" value="approved">
                                    <button type="submit" class="px-3 py-1 bg-green-500 hover:bg-green-600 text-white text-xs font-medium rounded transition-colors" title="Approve">
                                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                        </svg>
                                    </button>
                                </form>
                                <form method="POST" action="{{ route('loans.confirm', $loan) }}" class="inline">
                                    @csrf
                                    @method('PATCH')
                                    <input type="hidden" name="status" value="rejected">
                                    <button type="submit" class="px-3 py-1 bg-red-500 hover:bg-red-600 text-white text-xs font-medium rounded transition-colors" title="Reject">
                                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                                        </svg>
                                    </button>
                                </form>
                                <a href="{{ route('loans.show', $loan) }}" class="px-3 py-1 bg-gray-200 hover:bg-gray-300 text-gray-900 text-xs font-medium rounded transition-colors" title="View Details">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                    </svg>
                                </a>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
            @endif

            <!-- Payment Methods Breakdown -->
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 mb-8">
                <div class="bg-white rounded-xl shadow-soft p-6 animate-slide-up" style="animation-delay: 0.4s;">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4 font-display">Payment Methods</h3>
                    <div class="space-y-3">
                        @forelse($paymentMethods as $method)
                        <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                            <div class="flex items-center">
                                @php
                                    $colors = [
                                        'cash' => 'bg-green-100 text-green-600',
                                        'bank_transfer' => 'bg-blue-100 text-blue-600',
                                        'mobile_money' => 'bg-purple-100 text-purple-600',
                                    ];
                                    $color = $colors[$method->payment_method] ?? 'bg-gray-100 text-gray-600';
                                @endphp
                                <div class="w-10 h-10 rounded-lg {{ $color }} flex items-center justify-center mr-3">
                                    <span class="text-xs font-bold">{{ $method->count }}</span>
                                </div>
                                <div>
                                    <p class="text-sm font-medium text-gray-900">{{ ucfirst(str_replace('_', ' ', $method->payment_method)) }}</p>
                                    <p class="text-xs text-gray-500">{{ $method->count }} transactions</p>
                                </div>
                            </div>
                            <p class="text-sm font-semibold text-gray-900">TZS {{ number_format($method->total) }}</p>
                        </div>
                        @empty
                        <p class="text-sm text-gray-500 text-center py-4">No payment data</p>
                        @endforelse
                    </div>
                </div>

                <!-- Top Contributors -->
                <div class="bg-white rounded-xl shadow-soft p-6 animate-slide-up lg:col-span-2" style="animation-delay: 0.5s;">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4 font-display">Top Contributors</h3>
                    <div class="space-y-3">
                        @forelse($topContributors as $index => $contributor)
                        <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg hover:bg-gray-100 transition-colors">
                            <div class="flex items-center flex-1">
                                <div class="relative">
                                    <div class="w-12 h-12 bg-crextio-accent rounded-full flex items-center justify-center mr-4">
                                        <span class="text-lg font-bold text-gray-900">{{ $contributor->member ? substr($contributor->member->name, 0, 1) : '?' }}</span>
                                    </div>
                                    <div class="absolute -top-1 -right-1 w-6 h-6 bg-blue-500 rounded-full flex items-center justify-center text-white text-xs font-bold">
                                        {{ $index + 1 }}
                                    </div>
                                </div>
                                <div class="flex-1">
                                    <p class="text-sm font-medium text-gray-900">{{ $contributor->member->name ?? 'Unknown' }}</p>
                                    <p class="text-xs text-gray-500">{{ $contributor->contribution_count }} contributions</p>
                                </div>
                            </div>
                            <div class="text-right">
                                <p class="text-sm font-bold text-gray-900">TZS {{ number_format($contributor->total_contributed) }}</p>
                                <p class="text-xs text-gray-500">Total</p>
                            </div>
                        </div>
                        @empty
                        <p class="text-sm text-gray-500 text-center py-4">No contributor data</p>
                        @endforelse
                    </div>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="bg-white rounded-xl shadow-soft p-6 mb-8 animate-slide-up" style="animation-delay: 0.6s;">
                <h3 class="text-lg font-semibold text-gray-900 mb-4 font-display">Quick Actions</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                    <a href="{{ route('members.index') }}" class="flex items-center p-4 bg-blue-50 hover:bg-blue-100 rounded-lg transition-colors duration-300 group">
                        <div class="p-2 bg-blue-500 rounded-lg mr-3 group-hover:scale-110 transition-transform">
                            <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                            </svg>
                        </div>
                        <span class="text-sm font-medium text-gray-900">Manage Members</span>
                    </a>

                    <a href="{{ route('suggested-members.index') }}" class="flex items-center p-4 bg-purple-50 hover:bg-purple-100 rounded-lg transition-colors duration-300 group">
                        <div class="p-2 bg-purple-500 rounded-lg mr-3 group-hover:scale-110 transition-transform">
                            <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                            </svg>
                        </div>
                        <span class="text-sm font-medium text-gray-900">Review Suggestions</span>
                    </a>

                    <a href="{{ route('transactions.index') }}" class="flex items-center p-4 bg-green-50 hover:bg-green-100 rounded-lg transition-colors duration-300 group">
                        <div class="p-2 bg-green-500 rounded-lg mr-3 group-hover:scale-110 transition-transform">
                            <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                            </svg>
                        </div>
                        <span class="text-sm font-medium text-gray-900">View Transactions</span>
                    </a>

                    <a href="{{ route('reports.index') }}" class="flex items-center p-4 bg-yellow-50 hover:bg-yellow-100 rounded-lg transition-colors duration-300 group">
                        <div class="p-2 bg-crextio-accent rounded-lg mr-3 group-hover:scale-110 transition-transform">
                            <svg class="w-5 h-5 text-gray-900" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                            </svg>
                        </div>
                        <span class="text-sm font-medium text-gray-900">Generate Reports</span>
                    </a>
                </div>
            </div>

            <!-- Charts Section -->
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-8">
                <!-- Monthly Contributions Chart -->
                <div class="bg-white rounded-xl shadow-soft p-6 animate-slide-up" style="animation-delay: 0.7s;">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4 font-display">Monthly Contributions Trend</h3>
                    <div class="h-64">
                        <canvas id="monthlyChart"></canvas>
                    </div>
                </div>

                <!-- Member Growth Chart -->
                <div class="bg-white rounded-xl shadow-soft p-6 animate-slide-up" style="animation-delay: 0.8s;">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4 font-display">Member Growth (2024)</h3>
                    <div class="h-64">
                        <canvas id="memberGrowthChart"></canvas>
                    </div>
                </div>
            </div>

            <!-- Recent Transactions -->
            <div class="bg-white rounded-xl shadow-soft p-6 mb-8 animate-slide-up" style="animation-delay: 0.9s;">
                <h3 class="text-lg font-semibold text-gray-900 mb-4 font-display">Recent Transactions</h3>
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50 border-b border-gray-200">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase">Member</th>
                                <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase">Amount</th>
                                <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase">Type</th>
                                <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase">Method</th>
                                <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase">Date</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100">
                            @forelse($recentTransactions as $transaction)
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="flex items-center">
                                        <div class="h-8 w-8 bg-crextio-accent rounded-full flex items-center justify-center mr-3">
                                            <span class="text-xs font-medium text-gray-900">{{ $transaction->member ? substr($transaction->member->name, 0, 1) : '?' }}</span>
                                        </div>
                                        <span class="text-sm font-medium text-gray-900">{{ $transaction->member->name ?? 'Unknown' }}</span>
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="text-sm font-semibold text-gray-900">TZS {{ number_format($transaction->amount) }}</span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="text-sm text-gray-600">{{ ucfirst($transaction->transaction_type) }}</span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    @php
                                        $methodColors = [
                                            'cash' => 'bg-green-100 text-green-800',
                                            'bank_transfer' => 'bg-blue-100 text-blue-800',
                                            'mobile_money' => 'bg-purple-100 text-purple-800',
                                        ];
                                        $color = $methodColors[$transaction->payment_method] ?? 'bg-gray-100 text-gray-800';
                                    @endphp
                                    <span class="px-2 py-1 text-xs font-medium rounded-full {{ $color }}">
                                        {{ ucfirst(str_replace('_', ' ', $transaction->payment_method)) }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    {{ $transaction->created_at->diffForHumans() }}
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="5" class="px-6 py-8 text-center text-gray-500">No recent transactions</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Recent Members -->
            <div class="bg-white rounded-xl shadow-soft p-6 animate-slide-up" style="animation-delay: 1s;">
                <h3 class="text-lg font-semibold text-gray-900 mb-4 font-display">Recent Members</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                    @forelse($recentMembers as $member)
                    <div class="flex items-center p-4 bg-gray-50 rounded-lg hover:bg-gray-100 transition-colors">
                        <div class="h-12 w-12 bg-crextio-accent rounded-full flex items-center justify-center mr-4">
                            <span class="text-lg font-semibold text-gray-900">{{ substr($member->name, 0, 1) }}</span>
                        </div>
                        <div class="flex-1 min-w-0">
                            <p class="text-sm font-medium text-gray-900 truncate">{{ $member->name }}</p>
                            <p class="text-xs text-gray-500">{{ $member->phone }}</p>
                            <p class="text-xs text-gray-400">Joined {{ $member->created_at->diffForHumans() }}</p>
                        </div>
                    </div>
                    @empty
                    <div class="col-span-3 text-center py-8">
                        <p class="text-sm text-gray-500">No recent members</p>
                    </div>
                    @endforelse
                </div>
            </div>
    </div>

    @push('scripts')
    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Monthly Contributions Chart
            const monthlyCtx = document.getElementById('monthlyChart');
            if (monthlyCtx) {
                const monthlyData = @json($monthlyContributionsFull);
                const labels = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
                const data = Object.values(monthlyData);

                new Chart(monthlyCtx.getContext('2d'), {
                    type: 'line',
                    data: {
                        labels: labels,
                        datasets: [{
                            label: 'Monthly Contributions (TZS)',
                            data: data,
                            borderColor: '#FCD34D',
                            backgroundColor: 'rgba(252, 211, 77, 0.1)',
                            tension: 0.4,
                            fill: true,
                            pointBackgroundColor: '#FCD34D',
                            pointBorderColor: '#fff',
                            pointBorderWidth: 2,
                            pointRadius: 4,
                            pointHoverRadius: 6
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        plugins: {
                            legend: {
                                display: false
                            },
                            tooltip: {
                                backgroundColor: '#1F2937',
                                padding: 12,
                                titleColor: '#F9FAFB',
                                bodyColor: '#F9FAFB',
                                borderColor: '#FCD34D',
                                borderWidth: 1,
                                callbacks: {
                                    label: function(context) {
                                        return 'TZS ' + context.parsed.y.toLocaleString();
                                    }
                                }
                            }
                        },
                        scales: {
                            y: {
                                beginAtZero: true,
                                grid: {
                                    color: '#F3F4F6'
                                },
                                ticks: {
                                    callback: function(value) {
                                        return 'TZS ' + value.toLocaleString();
                                    },
                                    color: '#6B7280'
                                }
                            },
                            x: {
                                grid: {
                                    display: false
                                },
                                ticks: {
                                    color: '#6B7280'
                                }
                            }
                        }
                    }
                });
            }

            // Member Growth Chart
            const growthCtx = document.getElementById('memberGrowthChart');
            if (growthCtx) {
                const memberGrowthData = @json($monthlyMemberGrowth);
                const growthData = Object.values(memberGrowthData);
                const labels = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];

                new Chart(growthCtx.getContext('2d'), {
                    type: 'bar',
                    data: {
                        labels: labels,
                        datasets: [{
                            label: 'New Members',
                            data: growthData,
                            backgroundColor: '#3B82F6',
                            borderRadius: 8,
                            barThickness: 30
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        plugins: {
                            legend: {
                                display: false
                            },
                            tooltip: {
                                backgroundColor: '#1F2937',
                                padding: 12,
                                titleColor: '#F9FAFB',
                                bodyColor: '#F9FAFB',
                                borderColor: '#3B82F6',
                                borderWidth: 1
                            }
                        },
                        scales: {
                            y: {
                                beginAtZero: true,
                                grid: {
                                    color: '#F3F4F6'
                                },
                                ticks: {
                                    stepSize: 1,
                                    color: '#6B7280'
                                }
                            },
                            x: {
                                grid: {
                                    display: false
                                },
                                ticks: {
                                    color: '#6B7280'
                                }
                            }
                        }
                    }
                });
            }
        });
    </script>
    @endpush
</x-app-layout>
