<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Record Contribution') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-4xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white rounded-xl shadow-soft p-8 animate-slide-up">
                <div class="mb-8">
                    <h1 class="text-3xl font-bold text-crextio-text font-display">Record New Contribution</h1>
                    <p class="text-gray-600 mt-1">Fill in the details below to record a member's contribution.</p>
                </div>

                <form method="POST" action="{{ route('contributions.store') }}" class="space-y-6">
                    @csrf

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Member Selection -->
                        <div class="col-span-2">
                            <label for="member_id" class="block text-sm font-semibold text-gray-700 mb-2">Select Member</label>
                            <select name="member_id" id="member_id" required class="w-full px-4 py-3 border border-gray-200 rounded-lg focus:ring-2 focus:ring-crextio-accent focus:border-transparent transition-all">
                                <option value="">-- Search and Select Member --</option>
                                @foreach($members as $member)
                                    <option value="{{ $member->id }}" {{ old('member_id') == $member->id ? 'selected' : '' }}>
                                        {{ $member->name }} ({{ $member->phone }})
                                    </option>
                                @endforeach
                            </select>
                            <x-input-error :messages="$errors->get('member_id')" class="mt-2" />
                        </div>

                        <!-- Amount -->
                        <div>
                            <label for="amount" class="block text-sm font-semibold text-gray-700 mb-2">Amount (TZS)</label>
                            <div class="relative">
                                <span class="absolute left-4 top-1/2 -translate-y-1/2 text-gray-400 font-semibold">TZS</span>
                                <input type="number" name="amount" id="amount" value="{{ old('amount', 1000) }}" required min="0" step="100"
                                       class="w-full pl-14 pr-4 py-3 border border-gray-200 rounded-lg focus:ring-2 focus:ring-crextio-accent focus:border-transparent transition-all">
                            </div>
                            <x-input-error :messages="$errors->get('amount')" class="mt-2" />
                        </div>

                        <!-- Contribution Type -->
                        <div>
                            <label for="contribution_type" class="block text-sm font-semibold text-gray-700 mb-2">Contribution Type</label>
                            <select name="contribution_type" id="contribution_type" required class="w-full px-4 py-3 border border-gray-200 rounded-lg focus:ring-2 focus:ring-crextio-accent focus:border-transparent transition-all">
                                <option value="social" {{ old('contribution_type') == 'social' ? 'selected' : '' }}>Social Contribution</option>
                                <option value="share" {{ old('contribution_type') == 'share' ? 'selected' : '' }}>Share Capital</option>
                                 <option value="penalty" {{ old('contribution_type') == 'penalty' ? 'selected' : '' }}>Penalty</option>
                            </select>
                            <x-input-error :messages="$errors->get('contribution_type')" class="mt-2" />
                        </div>

                        <!-- Transaction ID / Receipt No -->
                        <div>
                            <label for="transaction_id" class="block text-sm font-semibold text-gray-700 mb-2">Transaction ID / Receipt No</label>
                            <input type="text" name="transaction_id" id="transaction_id" value="{{ old('transaction_id') }}" required placeholder="e.g. SIK123456"
                                   class="w-full px-4 py-3 border border-gray-200 rounded-lg focus:ring-2 focus:ring-crextio-accent focus:border-transparent transition-all">
                            <x-input-error :messages="$errors->get('transaction_id')" class="mt-2" />
                        </div>

                        <!-- Contribution Date -->
                        <div>
                            <label for="contribution_date" class="block text-sm font-semibold text-gray-700 mb-2">Date of Contribution</label>
                            <input type="date" name="contribution_date" id="contribution_date" value="{{ old('contribution_date', date('Y-m-d')) }}" required
                                   class="w-full px-4 py-3 border border-gray-200 rounded-lg focus:ring-2 focus:ring-crextio-accent focus:border-transparent transition-all">
                            <x-input-error :messages="$errors->get('contribution_date')" class="mt-2" />
                        </div>

                        <!-- Payment Method -->
                        <div>
                            <label for="payment_method" class="block text-sm font-semibold text-gray-700 mb-2">Payment Method</label>
                            <select name="payment_method" id="payment_method" required class="w-full px-4 py-3 border border-gray-200 rounded-lg focus:ring-2 focus:ring-crextio-accent focus:border-transparent transition-all">
                                <option value="mpesa" {{ old('payment_method') == 'mpesa' ? 'selected' : '' }}>M-Pesa</option>
                                <option value="cash" {{ old('payment_method') == 'cash' ? 'selected' : '' }}>Cash</option>
                                <option value="bank_transfer" {{ old('payment_method') == 'bank_transfer' ? 'selected' : '' }}>Bank Transfer</option>
                                <option value="cheque" {{ old('payment_method') == 'cheque' ? 'selected' : '' }}>Cheque</option>
                            </select>
                            <x-input-error :messages="$errors->get('payment_method')" class="mt-2" />
                        </div>

                        <!-- Description -->
                        <div class="col-span-2">
                            <label for="description" class="block text-sm font-semibold text-gray-700 mb-2">Notes / Description (Optional)</label>
                            <textarea name="description" id="description" rows="3" 
                                      class="w-full px-4 py-3 border border-gray-200 rounded-lg focus:ring-2 focus:ring-crextio-accent focus:border-transparent transition-all"
                                      placeholder="Any additional information...">{{ old('description') }}</textarea>
                            <x-input-error :messages="$errors->get('description')" class="mt-2" />
                        </div>
                    </div>

                    <div class="flex items-center justify-end pt-6 border-t border-gray-100 gap-4">
                        <a href="{{ route('contributions.index') }}" class="px-6 py-3 bg-gray-100 hover:bg-gray-200 text-gray-700 font-medium rounded-lg transition-all duration-300">
                            Cancel
                        </a>
                        <button type="submit" class="px-8 py-3 bg-crextio-text hover:bg-gray-800 text-white font-bold rounded-lg transition-all duration-300 shadow-soft hover:shadow-md">
                            Record Contribution
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-app-layout>
