<x-guest-layout>
    <div class="mb-8">
        <div class="flex justify-between items-center mb-8">
            <a href="/" class="text-2xl font-bold text-white font-display">AMU</a>
            <a href="/" class="text-sm text-gray-400 hover:text-white transition flex items-center">
                Back to website
                <svg class="w-4 h-4 ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3"></path></svg>
            </a>
        </div>
        
        <h2 class="text-4xl font-bold text-white mb-2 font-display">Create an account</h2>
        <p class="text-gray-400">Already have an account? <a href="{{ route('login') }}" class="text-amu-primary hover:text-amu-primaryHover transition">Log in</a></p>
    </div>

    <form method="POST" action="{{ route('register') }}" class="space-y-5">
        @csrf

        <!-- Name -->
        <div class="grid grid-cols-2 gap-4">
            <div>
                <input id="name" type="text" name="name" :value="old('name')" required autofocus autocomplete="name" placeholder="First name"
                       class="w-full bg-amu-input border-transparent focus:border-amu-primary focus:ring-0 rounded-lg px-4 py-3 text-white placeholder-gray-500 transition-colors">
                <x-input-error :messages="$errors->get('name')" class="mt-2" />
            </div>
            <div>
                <input type="text" placeholder="Last name" class="w-full bg-amu-input border-transparent focus:border-amu-primary focus:ring-0 rounded-lg px-4 py-3 text-white placeholder-gray-500 transition-colors">
            </div>
        </div>

        <!-- Email Address -->
        <div>
            <input id="email" type="email" name="email" :value="old('email')" required autocomplete="username" placeholder="Email"
                   class="w-full bg-amu-input border-transparent focus:border-amu-primary focus:ring-0 rounded-lg px-4 py-3 text-white placeholder-gray-500 transition-colors">
            <x-input-error :messages="$errors->get('email')" class="mt-2" />
        </div>

        <!-- Phone Number -->
        <div>
            <input id="phone" type="tel" name="phone" :value="old('phone')" required autocomplete="tel" placeholder="Phone Number"
                   class="w-full bg-amu-input border-transparent focus:border-amu-primary focus:ring-0 rounded-lg px-4 py-3 text-white placeholder-gray-500 transition-colors">
            <x-input-error :messages="$errors->get('phone')" class="mt-2" />
        </div>

        <!-- Password -->
        <div class="relative">
            <input id="password" type="password" name="password" required autocomplete="new-password" placeholder="Enter your password"
                   class="w-full bg-amu-input border-transparent focus:border-amu-primary focus:ring-0 rounded-lg px-4 py-3 text-white placeholder-gray-500 transition-colors">
            <button type="button" class="absolute inset-y-0 right-0 pr-3 flex items-center text-gray-500 hover:text-gray-300">
                <svg class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                </svg>
            </button>
            <x-input-error :messages="$errors->get('password')" class="mt-2" />
        </div>

        <!-- Confirm Password -->
        <div class="relative">
            <input id="password_confirmation" type="password" name="password_confirmation" required autocomplete="new-password" placeholder="Confirm your password"
                   class="w-full bg-amu-input border-transparent focus:border-amu-primary focus:ring-0 rounded-lg px-4 py-3 text-white placeholder-gray-500 transition-colors">
            <x-input-error :messages="$errors->get('password_confirmation')" class="mt-2" />
        </div>

        <!-- Terms -->
        <div class="flex items-center">
            <input id="terms" type="checkbox" class="rounded bg-amu-input border-transparent text-amu-primary focus:ring-amu-primary/50">
            <label for="terms" class="ms-2 text-sm text-gray-400">I agree to the <a href="#" class="text-white hover:underline">Terms & Conditions</a></label>
        </div>

        <button type="submit" class="w-full bg-amu-primary hover:bg-amu-primaryHover text-white font-medium py-3 rounded-lg transition-colors shadow-glow">
            {{ __('Create account') }}
        </button>

        <div class="relative my-6">
            <div class="absolute inset-0 flex items-center">
                <div class="w-full border-t border-gray-700"></div>
            </div>
            <div class="relative flex justify-center text-sm">
                <span class="px-2 bg-amu-bg text-gray-500">Or register with</span>
            </div>
        </div>

        <div class="grid grid-cols-2 gap-4">
            <button type="button" class="flex items-center justify-center px-4 py-2 border border-gray-700 rounded-lg text-white hover:bg-gray-800 transition">
                <img src="https://www.svgrepo.com/show/475656/google-color.svg" class="h-5 w-5 mr-2" alt="Google">
                Google
            </button>
            <button type="button" class="flex items-center justify-center px-4 py-2 border border-gray-700 rounded-lg text-white hover:bg-gray-800 transition">
                <svg class="h-5 w-5 mr-2 text-white" fill="currentColor" viewBox="0 0 24 24"><path d="M12 2C6.477 2 2 6.477 2 12c0 4.42 2.865 8.17 6.84 9.49.5.09.68-.22.68-.48v-1.71c-2.78.6-3.37-1.34-3.37-1.34-.45-1.15-1.11-1.46-1.11-1.46-.91-.62.07-.6.07-.6 1 .07 1.53 1.03 1.53 1.03.89 1.52 2.34 1.08 2.91.83.09-.65.35-1.09.63-1.34-2.22-.25-4.55-1.11-4.55-4.94 0-1.1.39-2 1.03-2.71-.1-.25-.45-1.29.1-2.64 0 0 .84-.27 2.75 1.02a9.56 9.56 0 012.5-.34c.85.01 1.7.11 2.5.34 1.91-1.29 2.75-1.02 2.75-1.02.55 1.35.2 2.39.1 2.64.65.71 1.03 1.6 1.03 2.71 0 3.84-2.34 4.68-4.57 4.93.36.31.68.92.68 1.85v2.75c0 .27.18.58.69.48A10.01 10.01 0 0022 12c0-5.523-4.477-10-10-10z"/></svg>
                GitHub
            </button>
        </div>
    </form>
</x-guest-layout>
