<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create admin user
        User::create([
            'name' => 'Admin User',
            'email' => 'admin@example.com',
            'password' => Hash::make('password'),
            'role' => 'admin',
        ]);

        // Create top-leader user
        User::create([
            'name' => 'Top Leader',
            'email' => 'topleader@example.com',
            'password' => Hash::make('password'),
            'role' => 'top-leader',
        ]);

        // Create leader user
        User::create([
            'name' => 'Leader',
            'email' => 'leader@example.com',
            'password' => Hash::make('password'),
            'role' => 'leader',
        ]);

        // Create regular user
        User::create([
            'name' => 'Regular User',
            'email' => 'user@example.com',
            'password' => Hash::make('password'),
            'role' => 'user',
        ]);
    }
}
