<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('contributions', function (Blueprint $table) {
            $table->string('contribution_type')->nullable()->after('amount'); // social or share
        });

        Schema::table('transactions', function (Blueprint $table) {
            $table->string('contribution_type')->nullable()->after('transaction_type'); // social or share
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('contributions', function (Blueprint $table) {
            $table->dropColumn('contribution_type');
        });

        Schema::table('transactions', function (Blueprint $table) {
            $table->dropColumn('contribution_type');
        });
    }
};
