<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add region column to users table
        Schema::table('users', function (Blueprint $table) {
            $table->string('region')->nullable()->after('role');
        });

        // Add leader_id column to members table
        Schema::table('members', function (Blueprint $table) {
            $table->unsignedBigInteger('leader_id')->nullable()->after('id');
            $table->foreign('leader_id')->references('id')->on('users')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('members', function (Blueprint $table) {
            $table->dropForeign(['leader_id']);
            $table->dropColumn('leader_id');
        });

        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn('region');
        });
    }
};
