<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('loans', function (Blueprint $table) {
            $table->timestamp('payment_date')->nullable()->after('approved_at');
            $table->decimal('payment_amount', 15, 2)->nullable()->after('payment_date');
            $table->enum('payment_method', ['cash', 'bank_transfer', 'mobile_money'])->nullable()->after('payment_amount');
            $table->text('notes')->nullable()->after('payment_method');
            $table->unsignedBigInteger('disbursed_by')->nullable()->after('notes');
            $table->timestamp('disbursed_at')->nullable()->after('disbursed_by');
            
            $table->foreign('disbursed_by')->references('id')->on('users');
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('loans', function (Blueprint $table) {
            $table->dropForeign(['disbursed_by']);
            $table->dropColumn([
                'payment_date',
                'payment_amount',
                'payment_method',
                'notes',
                'disbursed_by',
                'disbursed_at'
            ]);
        });

    }
};
