<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('suggested_members', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('phone');
            $table->string('church');
            $table->string('location');
            $table->enum('status', ['suggested', 'confirmed'])->default('suggested');
            $table->unsignedBigInteger('added_by'); // leader who added
            $table->unsignedBigInteger('confirmed_by')->nullable(); // top-leader who confirmed
            $table->timestamps();

            $table->foreign('added_by')->references('id')->on('users');
            $table->foreign('confirmed_by')->references('id')->on('users');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('suggested_members');
    }
};
