<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'role',
        'phone',
        'dob',
        'address',
        'region',
        'profile_picture',
    ];

    /**
     * Get the members managed by this user (for leaders).
     */
    public function members()
    {
        return $this->hasMany(Member::class, 'leader_id');
    }

    /**
     * Get the member profile associated with this user.
     */
    public function member()
    {
        return $this->hasOne(Member::class, 'phone', 'phone');
    }

    /**
     * Check if user is a leader.
     */
    public function isLeader()
    {
        return $this->role === 'leader';
    }

    /**
     * Check if user is a top-leader.
     */
    public function isTopLeader()
    {
        return in_array($this->role, ['top-leader', 'admin']);
    }

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }
}
