<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SuggestedMember extends Model
{
    protected $fillable = [
        'name',
        'phone',
        'church',
        'location',
        'status',
        'added_by',
        'confirmed_by',
    ];

    protected $casts = [
        'status' => 'string',
    ];

    public function adder()
    {
        return $this->belongsTo(User::class, 'added_by');
    }

    public function confirmer()
    {
        return $this->belongsTo(User::class, 'confirmed_by');
    }

    public function scopeSuggested($query)
    {
        return $query->where('status', 'suggested');
    }

    public function scopeConfirmed($query)
    {
        return $query->where('status', 'confirmed');
    }
}
