<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Member extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'phone',
        'church',
        'location',
        'role',
        'join_date',
        // 'message',
        'status',
        'leader_id',
        'current_balance',
    ];

    /**
     * Get the leader managing this member.
     */
    public function leader()
    {
        return $this->belongsTo(User::class, 'leader_id');
    }

    /**
     * Scope to filter members by leader.
     */
    public function scopeForLeader($query, $leaderId)
    {
        return $query->where('leader_id', $leaderId);
    }
    protected $casts = [
        'join_date' => 'date',
    ];

    public function scopeActive($query)
    {
        return $query->where('status', 'active');
    }

    public function contributions()
    {
        return $this->hasMany(Contribution::class, 'member_id');
    }

    public function transactions()
    {
        return $this->hasMany(Transaction::class, 'member_id');
    }

    public function penalties()
    {
        return $this->hasMany(Penalty::class, 'member_id');
    }
}
