<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Contribution extends Model
{
    protected $fillable = [
        'member_id',
        'amount',
        'contribution_type',
        'contribution_date',
        'payment_method',
        'transaction_id',
        'status',
    ];

    protected $casts = [
        'contribution_date' => 'date',
    ];

    public function member()
    {
        return $this->belongsTo(Member::class, 'member_id');
    }
}
