<?php

namespace App\Mail;

use App\Models\Loan;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class LoanRejectionMail extends Mailable
{
    use Queueable, SerializesModels;

    public $loan;
    public $rejectorName;
    public $reason;

    public function __construct(Loan $loan, string $rejectorName, string $reason = null)
    {
        $this->loan = $loan;
        $this->rejectorName = $rejectorName;
        $this->reason = $reason ?? 'Your loan application did not meet the approval criteria.';
    }

    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Loan Application Status Update',
        );
    }

    public function content(): Content
    {
        return new Content(
            markdown: 'emails.loan-rejection',
        );
    }

    public function attachments(): array
    {
        return [];
    }
}
