<?php

namespace App\Mail;

use App\Models\Loan;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class LoanApprovalMail extends Mailable
{
    use Queueable, SerializesModels;

    public $loan;
    public $approverName;
    public $isLeaderApproval;

    /**
     * Create a new message instance.
     */
    public function __construct(Loan $loan, string $approverName, bool $isLeaderApproval = false)
    {
        $this->loan = $loan;
        $this->approverName = $approverName;
        $this->isLeaderApproval = $isLeaderApproval;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        $subject = $this->isLeaderApproval 
            ? 'Loan Application Approved by Leader' 
            : 'Loan Application Fully Approved';
            
        return new Envelope(
            subject: $subject,
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            markdown: 'emails.loan-approval',
        );
    }

    /**
     * Get the attachments for the message.
     */
    public function attachments(): array
    {
        return [];
    }
}
