<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Message;

class MemberMessages extends Component
{
    public $messages;

    public function render()
    {
        $this->messages = Message::where('receiver_id', auth()->id())
            ->whereNull('replied_at')
            ->with('sender')
            ->orderBy('sent_at', 'desc')
            ->get();

        return view('livewire.member-messages');
    }

    public function markAsReplied($messageId)
    {
        $message = Message::find($messageId);
        if ($message && $message->receiver_id == auth()->id()) {
            $message->update(['replied_at' => now()]);
        }
    }
}
