<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class RegionalContextController extends Controller
{
    /**
     * Store the selected region in the session for filtering.
     */
    public function setSelectedRegion(Request $request)
    {
        $request->validate([
            'region' => 'nullable|string|max:255',
        ]);

        if ($request->region) {
            session(['selected_region' => $request->region]);
        } else {
            session()->forget('selected_region');
        }

        return redirect()->back()->with('success', 'Regional context updated.');
    }
}
