<?php

namespace App\Http\Controllers;

use App\Exports\ContributionsExport;
use App\Exports\TransactionsExport;
use App\Exports\LoansExport;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Http\Request;

class ExportController extends Controller
{
    /**
     * Export contributions data
     */
    public function exportContributions(Request $request)
    {
        $format = $request->get('format', 'xlsx');
        $filename = 'contributions_' . now()->format('Y-m-d') . '.' . $format;
        
        return Excel::download(new ContributionsExport, $filename);
    }

    /**
     * Export transactions data
     */
    public function exportTransactions(Request $request)
    {
        $format = $request->get('format', 'xlsx');
        $filename = 'transactions_' . now()->format('Y-m-d') . '.' . $format;
        
        return Excel::download(new TransactionsExport, $filename);
    }

    /**
     * Export loans data
     */
    public function exportLoans(Request $request)
    {
        $format = $request->get('format', 'xlsx');
        $filename = 'loans_' . now()->format('Y-m-d') . '.' . $format;
        
        return Excel::download(new LoansExport, $filename);
    }

    /**
     * Export monthly financial report
     */
    public function exportMonthlyReport(Request $request)
    {
        // This would be a more complex export with multiple sheets
        // For now, we'll export contributions as a simple report
        $filename = 'monthly_report_' . now()->format('Y-m') . '.xlsx';
        
        return Excel::download(new ContributionsExport, $filename);
    }
}
